/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpGetRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.UserInfoResponse;

public class UserInfoRequest
extends AbstractHttpGetRequest<UserInfoResponse> {
    private final String token;
    private boolean dpop = false;
    private String dpopProof;

    public UserInfoRequest(String token, AbstractOAuthClient<?> client) {
        super(client);
        this.token = token;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getUserInfo();
    }

    public UserInfoRequest dpop(String dpopProof) {
        this.dpop = true;
        this.dpopProof = dpopProof;
        return this;
    }

    @Override
    protected void initRequest() {
        String authorization = (this.dpop ? "DPoP" : "Bearer") + " " + this.token;
        this.header("Authorization", authorization);
        this.header("DPoP", this.dpopProof);
    }

    @Override
    protected UserInfoResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new UserInfoResponse(response);
    }
}

