/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.util.JsonSerialization;

public abstract class AbstractUrlBuilder {
    protected final AbstractOAuthClient<?> client;
    protected Map<String, String> params = new HashMap<String, String>();

    public AbstractUrlBuilder(AbstractOAuthClient<?> client) {
        this.client = client;
        this.initRequest();
    }

    public abstract String getEndpoint();

    protected abstract void initRequest();

    public void open() {
        this.client.driver.navigate().to(this.build());
    }

    protected void parameter(String name, String value) {
        this.params.put(name, value);
    }

    protected void parameter(String name, Object value) {
        try {
            String encoded = URLEncoder.encode(JsonSerialization.writeValueAsString((Object)value), StandardCharsets.UTF_8);
            this.parameter(name, encoded);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String build() {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.getEndpoint());
        this.params.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> uriBuilder.queryParam((String)e.getKey(), new Object[]{e.getValue()}));
        return uriBuilder.build(new Object[0]).toString();
    }
}

