/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth.device;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpResponse;

public class DeviceAuthorizationResponse
extends AbstractHttpResponse {
    private String deviceCode;
    private String userCode;
    private String verificationUri;
    private String verificationUriComplete;
    private int expiresIn;
    private int interval;

    public DeviceAuthorizationResponse(CloseableHttpResponse response) throws IOException {
        super(response);
    }

    @Override
    protected void parseContent() throws IOException {
        ObjectNode responseJson = this.asJson();
        this.deviceCode = responseJson.get("device_code").asText();
        this.userCode = responseJson.get("user_code").asText();
        this.verificationUri = responseJson.get("verification_uri").asText();
        this.verificationUriComplete = responseJson.get("verification_uri_complete").asText();
        this.expiresIn = responseJson.get("expires_in").asInt();
        this.interval = responseJson.get("interval").asInt();
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getVerificationUri() {
        return this.verificationUri;
    }

    public String getVerificationUriComplete() {
        return this.verificationUriComplete;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public int getInterval() {
        return this.interval;
    }
}

