/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.BackchannelLogoutResponse;

public class BackchannelLogoutRequest
extends AbstractHttpPostRequest<BackchannelLogoutRequest, BackchannelLogoutResponse> {
    private final String logoutToken;

    BackchannelLogoutRequest(String logoutToken, AbstractOAuthClient<?> client) {
        super(client);
        this.logoutToken = logoutToken;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getBackChannelLogout();
    }

    @Override
    protected void initRequest() {
        this.parameter("logout_token", this.logoutToken);
    }

    @Override
    protected BackchannelLogoutResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new BackchannelLogoutResponse(response);
    }
}

