/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth.ciba;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelResponse;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.ciba.AuthenticationRequestAcknowledgement;
import org.keycloak.testsuite.util.oauth.ciba.BackchannelAuthenticationRequest;
import org.keycloak.testsuite.util.oauth.ciba.BackchannelAuthenticationTokenRequest;
import org.keycloak.util.JsonSerialization;

public class CibaClient {
    private final AbstractOAuthClient<?> client;

    public CibaClient(AbstractOAuthClient<?> client) {
        this.client = client;
    }

    public BackchannelAuthenticationRequest backchannelAuthenticationRequest(String userid) {
        return new BackchannelAuthenticationRequest(userid, this.client);
    }

    public AuthenticationRequestAcknowledgement doBackchannelAuthenticationRequest(String userid) {
        return (AuthenticationRequestAcknowledgement)this.backchannelAuthenticationRequest(userid).send();
    }

    public BackchannelAuthenticationTokenRequest backchannelAuthenticationTokenRequest(String authReqId) {
        return new BackchannelAuthenticationTokenRequest(authReqId, this.client);
    }

    public AccessTokenResponse doBackchannelAuthenticationTokenRequest(String authReqId) {
        return (AccessTokenResponse)this.backchannelAuthenticationTokenRequest(authReqId).send();
    }

    public int doAuthenticationChannelCallback(String requestToken, AuthenticationChannelResponse.Status authStatus) throws Exception {
        HttpPost post = new HttpPost(this.client.getEndpoints().getBackchannelAuthenticationCallback());
        post.setHeader("Authorization", "Bearer " + requestToken);
        post.setEntity((HttpEntity)new StringEntity(JsonSerialization.writeValueAsString((Object)new AuthenticationChannelResponse(authStatus)), ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.client.httpClient().get().execute((HttpUriRequest)post);){
            int n = response.getStatusLine().getStatusCode();
            return n;
        }
    }
}

