/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.webdriver;

import java.time.Duration;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.keycloak.testframework.ui.page.AbstractPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WaitUtils {
    private final ManagedWebDriver managed;

    WaitUtils(ManagedWebDriver managed) {
        this.managed = managed;
    }

    public WaitUtils waitForPage(AbstractPage page) {
        String expectedPageId = page.getExpectedPageId();
        try {
            this.createDefaultWait().ignoring(StaleElementReferenceException.class).until(d -> expectedPageId.equals(this.managed.page().getCurrentPageId()));
        }
        catch (TimeoutException e) {
            Assertions.fail((String)("Expected page '" + expectedPageId + "' to be loaded, but currently on page '" + this.managed.page().getCurrentPageId() + "' after timeout"));
        }
        return this;
    }

    public WaitUtils waitForOAuthCallback() {
        try {
            this.createDefaultWait().until(d -> d.getCurrentUrl().contains("code=") || d.getCurrentUrl().contains("error="));
        }
        catch (TimeoutException e) {
            Assertions.fail((String)("Expected OAuth callback, but URL was '" + this.managed.getCurrentUrl() + "' after timeout"));
        }
        return this;
    }

    public WaitUtils waitForTitle(String title) {
        this.createDefaultWait().until(d -> d.getTitle().equals(title));
        return this;
    }

    public <V> V until(Function<WebDriver, V> isTrue) {
        return (V)this.createDefaultWait().until(isTrue);
    }

    private WebDriverWait createDefaultWait() {
        return new WebDriverWait(this.managed.driver(), Duration.ofSeconds(5L), Duration.ofMillis(50L));
    }
}

