/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import org.keycloak.testframework.ui.page.AbstractLoginPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class PasswordPage
extends AbstractLoginPage {
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="input-error-password")
    private WebElement passwordError;
    @FindBy(name="login")
    private WebElement submitButton;
    @FindBy(css="div[class^='pf-v5-c-alert'], div[class^='alert-error']")
    private WebElement loginErrorMessage;
    @FindBy(linkText="Forgot Password?")
    private WebElement resetPasswordLink;
    @FindBy(id="try-another-way")
    private WebElement tryAnotherWayLink;

    public PasswordPage(ManagedWebDriver driver) {
        super(driver);
    }

    public void fillPassword(String password) {
        this.passwordInput.clear();
        this.passwordInput.sendKeys(new CharSequence[]{password});
    }

    public void submit() {
        this.submitButton.click();
    }

    public String getPassword() {
        return this.passwordInput.getAttribute("value");
    }

    public String getError() {
        try {
            return this.loginErrorMessage.getText();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void clickTryAnotherWayLink() {
        this.tryAnotherWayLink.click();
    }

    @Override
    public String getExpectedPageId() {
        return "login-login-password";
    }
}

