/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import org.keycloak.testframework.ui.page.AbstractLoginPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginPage
extends AbstractLoginPage {
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(css="[type=submit]")
    private WebElement submitButton;
    @FindBy(id="rememberMe")
    private WebElement rememberMe;
    @FindBy(linkText="Forgot Password?")
    private WebElement resetPasswordLink;
    @FindBy(className="pf-m-success")
    private WebElement loginSuccessMessage;
    @FindBy(id="input-error-username")
    private WebElement userNameInputError;

    public LoginPage(ManagedWebDriver driver) {
        super(driver);
    }

    public void fillLogin(String username, String password) {
        this.usernameInput.clear();
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.passwordInput.clear();
        this.passwordInput.sendKeys(new CharSequence[]{password});
    }

    public void submit() {
        this.submitButton.click();
    }

    public void clickSocial(String alias) {
        WebElement socialButton = this.findSocialButton(alias);
        socialButton.click();
    }

    public WebElement findSocialButton(String alias) {
        String id = "social-" + alias;
        return this.driver.findElement(By.id((String)id));
    }

    public void rememberMe(boolean value) {
        boolean selected = this.isRememberMe();
        if (value && !selected || !value && selected) {
            this.rememberMe.click();
        }
    }

    public boolean isRememberMe() {
        return this.rememberMe.isSelected();
    }

    public void resetPassword() {
        this.resetPasswordLink.click();
    }

    public String getSuccessMessage() {
        return this.loginSuccessMessage != null ? this.loginSuccessMessage.getText() : null;
    }

    @Override
    public String getExpectedPageId() {
        return "login-login";
    }

    public String getUsername() {
        return this.usernameInput.getAttribute("value");
    }

    public void clearUsernameInput() {
        this.usernameInput.clear();
    }

    public String getUsernameInputError() {
        try {
            return this.userNameInputError.getText();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

