/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import org.keycloak.testframework.ui.page.AbstractPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public abstract class AbstractLoginPage
extends AbstractPage {
    @FindBy(xpath="//select[@aria-label='languages']/option[@selected]")
    private WebElement selectedLanguage;
    @FindBy(xpath="//select[@aria-label='languages']")
    private WebElement languages;
    @FindBy(id="kc-current-locale-link")
    private WebElement languageTextBase;
    @FindBy(id="kc-locale-dropdown")
    private WebElement localeDropdownBase;

    public AbstractLoginPage(ManagedWebDriver driver) {
        super(driver);
    }

    public String getSelectedLanguage() {
        try {
            String text = this.selectedLanguage.getText();
            return text == null ? text : text.trim();
        }
        catch (NoSuchElementException ex) {
            return this.languageTextBase.getText();
        }
    }

    public void selectLanguage(String language) {
        try {
            WebElement langLink = this.languages.findElement(By.xpath((String)("//option[text()[contains(.,'" + language + "')]]")));
            langLink.click();
        }
        catch (NoSuchElementException ex) {
            WebElement langLink = this.localeDropdownBase.findElement(By.xpath((String)("//a[text()[contains(.,'" + language + "')]]")));
            langLink.click();
        }
    }
}

