/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.webdriver;

import java.lang.reflect.Constructor;
import org.keycloak.testframework.ui.page.AbstractPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.support.PageFactory;

public class PageUtils {
    private final ManagedWebDriver managed;

    PageUtils(ManagedWebDriver managed) {
        this.managed = managed;
    }

    public <S extends AbstractPage> S createPage(Class<S> valueType) {
        try {
            Constructor<S> constructor = valueType.getDeclaredConstructor(ManagedWebDriver.class);
            AbstractPage page = (AbstractPage)constructor.newInstance(this.managed);
            PageFactory.initElements((SearchContext)this.managed.driver(), (Object)page);
            return (S)page;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getCurrentPageId() {
        return this.managed.findElement(By.xpath((String)"//body")).getAttribute("data-page-id");
    }

    public String getTitle() {
        return this.managed.driver().getTitle();
    }

    public String getPageSource() {
        return this.managed.driver().getPageSource();
    }
}

