/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import org.keycloak.testframework.ui.page.AbstractPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class WelcomePage
extends AbstractPage {
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="firstName")
    private WebElement firstNameInput;
    @FindBy(id="lastName")
    private WebElement lastNameInput;
    @FindBy(id="email")
    private WebElement emailInput;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="password-confirmation")
    private WebElement passwordConfirmationInput;
    @FindBy(xpath="//button")
    private WebElement submitButton;
    @FindBy(css=".pf-v5-c-alert")
    private WebElement pageAlert;
    @FindBy(css=".pf-v5-c-title")
    private WebElement welcomeMessage;
    @FindBy(css=".pf-v5-c-login__main-header-desc")
    private WebElement welcomeDescription;
    @FindBy(css=".pf-v5-c-button")
    private WebElement openAdminConsoleLink;

    public WelcomePage(ManagedWebDriver driver) {
        super(driver);
    }

    public void fillRegistration(String username, String password) {
        this.fillRegistration(username, null, null, null, password);
    }

    public void fillRegistration(String username, String firstName, String lastName, String email, String password) {
        this.usernameInput.sendKeys(new CharSequence[]{username});
        if (firstName != null) {
            this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        }
        if (lastName != null) {
            this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        }
        if (email != null) {
            this.emailInput.sendKeys(new CharSequence[]{email});
        }
        this.passwordInput.sendKeys(new CharSequence[]{password});
        this.passwordConfirmationInput.sendKeys(new CharSequence[]{password});
    }

    public void submit() {
        this.submitButton.click();
    }

    public void clickOpenAdminConsole() {
        this.openAdminConsoleLink.click();
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage.getText();
    }

    public String getWelcomeDescription() {
        return this.welcomeDescription.getText();
    }

    public String getPageAlert() {
        return this.pageAlert.getText();
    }

    @Override
    public String getExpectedPageId() {
        return "welcome";
    }
}

