/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import java.util.List;
import org.keycloak.testframework.ui.page.AbstractLoginPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class SelectAuthenticatorPage
extends AbstractLoginPage {
    public static final String PASSWORD = "Password";
    public static final String SECURITY_KEY = "Passkey";

    public SelectAuthenticatorPage(ManagedWebDriver driver) {
        super(driver);
    }

    public void selectLoginMethod(String loginMethodName) {
        this.getLoginMethodRowByName(loginMethodName).click();
    }

    public String getLoginMethodHelpText(String loginMethodName) {
        return this.getLoginMethodRowByName(loginMethodName).findElement(By.className((String)"select-auth-box-desc")).getText();
    }

    private List<WebElement> getLoginMethodsRows() {
        return this.driver.driver().findElements(By.className((String)"select-auth-box-parent"));
    }

    private String getLoginMethodNameFromRow(WebElement loginMethodRow) {
        return loginMethodRow.findElement(By.className((String)"select-auth-box-headline")).getText();
    }

    private WebElement getLoginMethodRowByName(String loginMethodName) {
        return this.getLoginMethodsRows().stream().filter(loginMethodRow -> loginMethodName.equals(this.getLoginMethodNameFromRow((WebElement)loginMethodRow))).findFirst().orElseThrow(() -> new AssertionError((Object)("Login method '" + loginMethodName + "' not found in the available authentication mechanisms")));
    }

    @Override
    public String getExpectedPageId() {
        return "login-select-authenticator";
    }
}

