/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import org.keycloak.testframework.ui.page.AbstractLoginPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginPasswordUpdatePage
extends AbstractLoginPage {
    @FindBy(id="password-new")
    private WebElement newPasswordInput;
    @FindBy(id="password-confirm")
    private WebElement passwordConfirmInput;
    @FindBy(css="[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(css="div[class^='pf-v5-c-alert'], div[class^='alert-error']")
    private WebElement loginErrorMessage;
    @FindBy(className="kc-feedback-text")
    private WebElement feedbackMessage;
    @FindBy(name="cancel-aia")
    private WebElement cancelAIAButton;

    public LoginPasswordUpdatePage(ManagedWebDriver driver) {
        super(driver);
    }

    public void changePassword(String newPassword, String passwordConfirm) {
        this.newPasswordInput.sendKeys(new CharSequence[]{newPassword});
        this.passwordConfirmInput.sendKeys(new CharSequence[]{passwordConfirm});
        this.submitButton.click();
    }

    public void cancel() {
        this.cancelAIAButton.click();
    }

    public String getError() {
        return this.loginErrorMessage != null ? this.loginErrorMessage.getText() : null;
    }

    public String getFeedbackMessage() {
        return this.feedbackMessage.getText();
    }

    public boolean isCancelDisplayed() {
        return this.cancelAIAButton.isDisplayed();
    }

    @Override
    public String getExpectedPageId() {
        return "login-login-update-password";
    }
}

