/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class AbstractPage {
    @FindBy(xpath="//body")
    private WebElement body;
    protected final WebDriver driver;

    public AbstractPage(WebDriver driver) {
        this.driver = driver;
        PageFactory.initElements((SearchContext)driver, (Object)this);
    }

    public abstract String getExpectedPageId();

    public String getCurrentPageId() {
        return this.body.getAttribute("data-page-id");
    }

    public void waitForPage() {
        try {
            new WebDriverWait(this.driver, Duration.ofSeconds(10L)).until(d -> this.isActivePage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Waiting for '" + this.getExpectedPageId() + "', but was '" + this.getCurrentPageId() + "'");
        }
    }

    private boolean isActivePage() {
        return this.getExpectedPageId().equals(this.getCurrentPageId());
    }

    public void assertCurrent() {
        Assertions.assertEquals((Object)this.getExpectedPageId(), (Object)this.getCurrentPageId(), (String)"Not on the expected page");
    }
}

