/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.remote.runonserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class TestClassServer {
    public static final String CONTEXT_PATH = "/test-classes/";
    private final HttpServer httpServer;
    public static final Set<String> DEFAULT_PERMITTED_PACKAGES = Set.of("org.keycloak.testframework", "org.junit", "org.opentest4j");
    private final Set<String> permittedPackages;

    TestClassServer(HttpServer httpServer) {
        this.httpServer = httpServer;
        this.permittedPackages = new HashSet<String>(DEFAULT_PERMITTED_PACKAGES);
        httpServer.createContext(CONTEXT_PATH, new TestClassPathHandler());
    }

    public void addPermittedPackages(Set<String> permittedPackages) {
        this.permittedPackages.addAll(permittedPackages);
    }

    public void close() {
        this.httpServer.removeContext(CONTEXT_PATH);
    }

    private class TestClassPathHandler
    implements HttpHandler {
        private TestClassPathHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            String resource = httpExchange.getRequestURI().getPath().substring(TestClassServer.CONTEXT_PATH.length() - 1);
            Headers respHeaders = httpExchange.getResponseHeaders();
            respHeaders.set("Content-Type", "application/x-java-applet;charset=utf-8");
            if (!this.isPermittedPackage(resource) || !resource.endsWith(".class") && !resource.endsWith(".json")) {
                httpExchange.sendResponseHeaders(403, 0L);
            } else {
                try (InputStream resourceStream = TestClassServer.class.getResourceAsStream(resource);){
                    if (resourceStream != null) {
                        byte[] bytes = resourceStream.readAllBytes();
                        httpExchange.sendResponseHeaders(200, bytes.length);
                        httpExchange.getResponseBody().write(bytes);
                    } else {
                        httpExchange.sendResponseHeaders(404, 0L);
                    }
                }
            }
            httpExchange.close();
        }

        private boolean isPermittedPackage(String className) {
            String c = className.substring(1).replace('/', '.');
            for (String p : TestClassServer.this.permittedPackages) {
                if (!c.startsWith(p)) continue;
                return true;
            }
            return false;
        }
    }
}

