/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.remote.runonserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.keycloak.testframework.injection.DependenciesBuilder;
import org.keycloak.testframework.injection.Dependency;
import org.keycloak.testframework.injection.InstanceContext;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.injection.RequestedInstance;
import org.keycloak.testframework.injection.Supplier;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.RemoteProviders;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.remote.runonserver.TestClassServer;
import org.keycloak.testframework.server.KeycloakServer;

public class RunOnServerSupplier
implements Supplier<RunOnServerClient, InjectRunOnServer> {
    public List<Dependency> getDependencies(RequestedInstance<RunOnServerClient, InjectRunOnServer> instanceContext) {
        return DependenciesBuilder.create(HttpClient.class).add(KeycloakServer.class).add(ManagedRealm.class, ((InjectRunOnServer)instanceContext.getAnnotation()).realmRef()).add(RemoteProviders.class).add(TestClassServer.class).build();
    }

    public RunOnServerClient getValue(InstanceContext<RunOnServerClient, InjectRunOnServer> instanceContext) {
        KeycloakServer server = (KeycloakServer)instanceContext.getDependency(KeycloakServer.class);
        HttpClient httpClient = (HttpClient)instanceContext.getDependency(HttpClient.class);
        ManagedRealm realm = (ManagedRealm)instanceContext.getDependency(ManagedRealm.class, ((InjectRunOnServer)instanceContext.getAnnotation()).realmRef());
        instanceContext.getDependency(RemoteProviders.class);
        TestClassServer testClassServer = (TestClassServer)instanceContext.getDependency(TestClassServer.class);
        String[] permittedPackages = ((InjectRunOnServer)instanceContext.getAnnotation()).permittedPackages();
        testClassServer.addPermittedPackages(new HashSet<String>(Arrays.asList(permittedPackages)));
        return new RunOnServerClient(httpClient, realm.getBaseUrl(), server.hashCode());
    }

    public boolean compatible(InstanceContext<RunOnServerClient, InjectRunOnServer> a, RequestedInstance<RunOnServerClient, InjectRunOnServer> b) {
        return ((InjectRunOnServer)a.getAnnotation()).realmRef().equals(((InjectRunOnServer)b.getAnnotation()).realmRef());
    }

    public LifeCycle getDefaultLifecycle() {
        return LifeCycle.METHOD;
    }

    public int order() {
        return 100;
    }
}

