/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.remote.timeoffset;

import org.apache.http.client.HttpClient;
import org.keycloak.testframework.injection.InstanceContext;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.injection.RequestedInstance;
import org.keycloak.testframework.injection.Supplier;
import org.keycloak.testframework.remote.RemoteProviders;
import org.keycloak.testframework.remote.timeoffset.InjectTimeOffSet;
import org.keycloak.testframework.remote.timeoffset.TimeOffSet;
import org.keycloak.testframework.server.KeycloakUrls;

public class TimeOffsetSupplier
implements Supplier<TimeOffSet, InjectTimeOffSet> {
    public TimeOffSet getValue(InstanceContext<TimeOffSet, InjectTimeOffSet> instanceContext) {
        HttpClient httpClient = (HttpClient)instanceContext.getDependency(HttpClient.class);
        RemoteProviders remoteProviders = (RemoteProviders)instanceContext.getDependency(RemoteProviders.class);
        KeycloakUrls keycloakUrls = (KeycloakUrls)instanceContext.getDependency(KeycloakUrls.class);
        int initOffset = ((InjectTimeOffSet)instanceContext.getAnnotation()).offset();
        return new TimeOffSet(httpClient, keycloakUrls.getMasterRealm(), initOffset);
    }

    public boolean compatible(InstanceContext<TimeOffSet, InjectTimeOffSet> a, RequestedInstance<TimeOffSet, InjectTimeOffSet> b) {
        return true;
    }

    public LifeCycle getDefaultLifecycle() {
        return LifeCycle.METHOD;
    }

    public void close(InstanceContext<TimeOffSet, InjectTimeOffSet> instanceContext) {
        TimeOffSet timeOffSet = (TimeOffSet)instanceContext.getValue();
        if (timeOffSet.hasChanged()) {
            timeOffSet.set(0);
        }
    }

    public int order() {
        return 100;
    }
}

