/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.remote.timeoffset;

import java.util.Set;
import org.apache.http.client.HttpClient;
import org.keycloak.testframework.injection.InstanceContext;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.injection.RequestedInstance;
import org.keycloak.testframework.injection.Supplier;
import org.keycloak.testframework.remote.RemoteProviders;
import org.keycloak.testframework.remote.timeoffset.InjectTimeOffSet;
import org.keycloak.testframework.remote.timeoffset.TimeOffSet;
import org.keycloak.testframework.server.KeycloakUrls;

public class TimeOffsetSupplier
implements Supplier<TimeOffSet, InjectTimeOffSet> {
    public Class<InjectTimeOffSet> getAnnotationClass() {
        return InjectTimeOffSet.class;
    }

    public Class<TimeOffSet> getValueType() {
        return TimeOffSet.class;
    }

    public Set<Class<?>> dependencies() {
        return Set.of(HttpClient.class, RemoteProviders.class, KeycloakUrls.class);
    }

    public TimeOffSet getValue(InstanceContext<TimeOffSet, InjectTimeOffSet> instanceContext) {
        HttpClient httpClient = (HttpClient)instanceContext.getDependency(HttpClient.class);
        RemoteProviders remoteProviders = (RemoteProviders)instanceContext.getDependency(RemoteProviders.class);
        KeycloakUrls keycloakUrls = (KeycloakUrls)instanceContext.getDependency(KeycloakUrls.class);
        int initOffset = ((InjectTimeOffSet)instanceContext.getAnnotation()).offset();
        return new TimeOffSet(httpClient, keycloakUrls.getMasterRealm(), initOffset);
    }

    public boolean compatible(InstanceContext<TimeOffSet, InjectTimeOffSet> a, RequestedInstance<TimeOffSet, InjectTimeOffSet> b) {
        return true;
    }

    public LifeCycle getDefaultLifecycle() {
        return LifeCycle.METHOD;
    }

    public void close(InstanceContext<TimeOffSet, InjectTimeOffSet> instanceContext) {
        TimeOffSet timeOffSet;
        if (instanceContext.getLifeCycle() != LifeCycle.METHOD && (timeOffSet = (TimeOffSet)instanceContext.getValue()).hasChanged()) {
            timeOffSet.set(0);
        }
    }

    public int order() {
        return 100;
    }
}

