/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.remote.providers.runonserver;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServer;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.providers.runonserver.SerializationUtil;
import org.keycloak.util.JsonSerialization;

public class RunOnServerRealmResourceProvider
implements RealmResourceProvider {
    private final KeycloakSession session;
    private final ClassLoader classLoader;

    public RunOnServerRealmResourceProvider(KeycloakSession session, ClassLoader classLoader) {
        this.session = session;
        this.classLoader = classLoader;
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @POST
    @Path(value="/")
    @Consumes(value={"text/plain;charset=utf-8"})
    @Produces(value={"text/plain;charset=utf-8"})
    public String runOnServer(String runOnServer) {
        try {
            Object o = SerializationUtil.decode(runOnServer, this.classLoader);
            if (o instanceof FetchOnServer) {
                FetchOnServer f = (FetchOnServer)o;
                Object result = f.run(this.session);
                return result != null ? JsonSerialization.writeValueAsString((Object)result) : null;
            }
            if (o instanceof RunOnServer) {
                RunOnServer r = (RunOnServer)o;
                r.run(this.session);
                return null;
            }
            throw new IllegalArgumentException("Can't handle serialized class: " + o.getClass().getName());
        }
        catch (Throwable t) {
            return SerializationUtil.encodeException(t);
        }
    }
}

