/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.oauth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.util.HashMap;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.crypto.ECDSASignatureSignerContext;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.def.DefaultCryptoProvider;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.testframework.oauth.OAuthIdentityProviderConfigBuilder;
import org.keycloak.util.JsonSerialization;

public class OAuthIdentityProvider {
    private final HttpServer httpServer;
    private final OAuthIdentityProviderKeys keys;
    private final OAuthIdentityProviderConfigBuilder.OAuthIdentityProviderConfiguration config;
    private int keysRequestCount = 0;

    public OAuthIdentityProvider(HttpServer httpServer, OAuthIdentityProviderConfigBuilder.OAuthIdentityProviderConfiguration config) {
        this.config = config;
        if (!CryptoIntegration.isInitialised()) {
            CryptoIntegration.setProvider((CryptoProvider)new DefaultCryptoProvider());
        }
        this.httpServer = httpServer;
        httpServer.createContext("/idp/.well-known/openid-configuration", new WellKnownHandler());
        httpServer.createContext("/idp/jwks", new JwksHttpHandler());
        this.keys = new OAuthIdentityProviderKeys(config);
    }

    public String encodeToken(JsonWebToken token) {
        return this.encodeToken(token, this.keys);
    }

    public String encodeToken(JsonWebToken token, OAuthIdentityProviderKeys keys) {
        return new JWSBuilder().type("JWT").jsonContent((Object)token).sign((SignatureSignerContext)new ECDSASignatureSignerContext(keys.getKeyWrapper()));
    }

    public OAuthIdentityProviderKeys createKeys() {
        return new OAuthIdentityProviderKeys(this.config);
    }

    public OAuthIdentityProviderKeys getKeys() {
        return this.keys;
    }

    public int getKeysRequestCount() {
        return this.keysRequestCount;
    }

    public void close() {
        this.httpServer.removeContext("/idp/.well-known/openid-configuration");
        this.httpServer.removeContext("/idp/jwks");
    }

    public class WellKnownHandler
    implements HttpHandler {
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            OIDCConfigurationRepresentation oidcConfig = new OIDCConfigurationRepresentation();
            oidcConfig.setJwksUri("http://127.0.0.1:8500/idp/jwks");
            String oidcConfigString = JsonSerialization.writeValueAsString((Object)oidcConfig);
            exchange.getResponseHeaders().add("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, oidcConfigString.length());
            OutputStream outputStream = exchange.getResponseBody();
            outputStream.write(oidcConfigString.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
    }

    public class JwksHttpHandler
    implements HttpHandler {
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            boolean kubernetes = OAuthIdentityProviderConfigBuilder.Mode.KUBERNETES.equals((Object)OAuthIdentityProvider.this.config.mode());
            if (kubernetes) {
                exchange.getResponseHeaders().add("Content-Type", "application/jwk-set+json");
            } else {
                exchange.getResponseHeaders().add("Content-Type", "application/json");
            }
            exchange.sendResponseHeaders(200, OAuthIdentityProvider.this.keys.getJwksString().length());
            OutputStream outputStream = exchange.getResponseBody();
            outputStream.write(OAuthIdentityProvider.this.keys.getJwksString().getBytes(StandardCharsets.UTF_8));
            outputStream.close();
            ++OAuthIdentityProvider.this.keysRequestCount;
        }
    }

    public static class OAuthIdentityProviderKeys {
        private final KeyWrapper keyWrapper;
        private final String jwksString;

        public OAuthIdentityProviderKeys(OAuthIdentityProviderConfigBuilder.OAuthIdentityProviderConfiguration config) {
            try {
                boolean spiffe = OAuthIdentityProviderConfigBuilder.Mode.SPIFFE.equals((Object)config.mode());
                KeyUse keyUse = spiffe ? KeyUse.JWT_SVID : KeyUse.SIG;
                KeyPair keyPair = KeyUtils.generateEcKeyPair((String)"secp256r1");
                JWK jwk = JWKBuilder.create().ec((Key)keyPair.getPublic());
                if (!spiffe) {
                    jwk.setAlgorithm("ES256");
                }
                if (config.jwkUse()) {
                    jwk.setPublicKeyUse(keyUse.getSpecName());
                } else {
                    jwk.setPublicKeyUse(null);
                }
                HashMap<String, Object> jwks = new HashMap<String, Object>();
                jwks.put("keys", new JWK[]{jwk});
                if (spiffe) {
                    jwks.put("spiffe_sequence", 1);
                    jwks.put("spiffe_refresh_hint", 300);
                }
                this.jwksString = JsonSerialization.writeValueAsString(jwks);
                this.keyWrapper = new KeyWrapper();
                this.keyWrapper.setKid(jwk.getKeyId());
                this.keyWrapper.setPublicKey((Key)keyPair.getPublic());
                this.keyWrapper.setPrivateKey((Key)keyPair.getPrivate());
                this.keyWrapper.setUse(KeyUse.SIG);
                this.keyWrapper.setAlgorithm("ES256");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public KeyWrapper getKeyWrapper() {
            return this.keyWrapper;
        }

        public String getJwksString() {
            return this.jwksString;
        }
    }
}

