/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.oauth;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testframework.injection.DependenciesBuilder;
import org.keycloak.testframework.injection.Dependency;
import org.keycloak.testframework.injection.InstanceContext;
import org.keycloak.testframework.injection.RequestedInstance;
import org.keycloak.testframework.injection.Supplier;
import org.keycloak.testframework.injection.SupplierHelpers;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.TestApp;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.keycloak.testframework.util.ApiUtil;

public class OAuthClientSupplier
implements Supplier<OAuthClient, InjectOAuthClient> {
    public List<Dependency> getDependencies(RequestedInstance<OAuthClient, InjectOAuthClient> instanceContext) {
        return DependenciesBuilder.create(KeycloakUrls.class).add(HttpClient.class).add(ManagedWebDriver.class).add(TestApp.class).add(ManagedRealm.class, ((InjectOAuthClient)instanceContext.getAnnotation()).realmRef()).build();
    }

    public OAuthClient getValue(InstanceContext<OAuthClient, InjectOAuthClient> instanceContext) {
        InjectOAuthClient annotation = (InjectOAuthClient)instanceContext.getAnnotation();
        KeycloakUrls keycloakUrls = (KeycloakUrls)instanceContext.getDependency(KeycloakUrls.class);
        CloseableHttpClient httpClient = (CloseableHttpClient)instanceContext.getDependency(HttpClient.class);
        ManagedWebDriver webDriver = (ManagedWebDriver)instanceContext.getDependency(ManagedWebDriver.class);
        TestApp testApp = (TestApp)instanceContext.getDependency(TestApp.class);
        ManagedRealm realm = (ManagedRealm)instanceContext.getDependency(ManagedRealm.class, annotation.realmRef());
        String redirectUri = testApp.getRedirectionUri();
        ClientConfig clientConfig = (ClientConfig)SupplierHelpers.getInstance(annotation.config());
        ClientRepresentation testAppClient = clientConfig.configure(ClientConfigBuilder.create()).redirectUris(new String[]{redirectUri}).build();
        if (annotation.kcAdmin()) {
            testAppClient.setAdminUrl(testApp.getAdminUri());
        }
        String clientId = testAppClient.getClientId();
        String clientSecret = testAppClient.getSecret();
        ApiUtil.getCreatedId((Response)realm.admin().clients().create(testAppClient));
        OAuthClient oAuthClient = new OAuthClient(keycloakUrls.getBase(), httpClient, webDriver);
        oAuthClient.config().realm(realm.getName()).client(clientId, clientSecret).redirectUri(redirectUri);
        return oAuthClient;
    }

    public boolean compatible(InstanceContext<OAuthClient, InjectOAuthClient> a, RequestedInstance<OAuthClient, InjectOAuthClient> b) {
        return ((InjectOAuthClient)a.getAnnotation()).ref().equals(((InjectOAuthClient)b.getAnnotation()).ref());
    }

    public void close(InstanceContext<OAuthClient, InjectOAuthClient> instanceContext) {
        ((OAuthClient)((Object)instanceContext.getValue())).close();
    }
}

