/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.oauth;

import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AuthorizationEndpointResponse;
import org.keycloak.testsuite.util.oauth.OAuthClientConfig;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.support.PageFactory;

public class OAuthClient
extends AbstractOAuthClient<OAuthClient> {
    private final ManagedWebDriver managedWebDriver;

    public OAuthClient(String baseUrl, CloseableHttpClient httpClient, ManagedWebDriver managedWebDriver) {
        super(baseUrl, httpClient, managedWebDriver.driver());
        this.managedWebDriver = managedWebDriver;
        this.config = new OAuthClientConfig().responseType("code");
    }

    public void fillLoginForm(String username, String password) {
        LoginPage loginPage = new LoginPage(this.managedWebDriver);
        PageFactory.initElements((SearchContext)this.driver, (Object)loginPage);
        loginPage.fillLogin(username, password);
        loginPage.submit();
    }

    public AuthorizationEndpointResponse parseLoginResponse() {
        this.managedWebDriver.waiting().waitForOAuthCallback();
        return super.parseLoginResponse();
    }

    public ClientRegistration clientRegistration() {
        return ClientRegistration.create().httpClient((HttpClient)this.httpClient().get()).url(this.baseUrl, this.config.getRealm()).build();
    }

    public void close() {
    }
}

