/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.oauth;

public class OAuthIdentityProviderConfigBuilder {
    private Mode mode = Mode.DEFAULT;
    private boolean jwkUse = true;

    public OAuthIdentityProviderConfigBuilder spiffe() {
        this.mode = Mode.SPIFFE;
        return this;
    }

    public OAuthIdentityProviderConfigBuilder kubernetes() {
        this.mode = Mode.KUBERNETES;
        return this;
    }

    public OAuthIdentityProviderConfigBuilder jwkUse(boolean jwkUse) {
        this.jwkUse = jwkUse;
        return this;
    }

    public OAuthIdentityProviderConfiguration build() {
        return new OAuthIdentityProviderConfiguration(this.mode, this.jwkUse);
    }

    public static enum Mode {
        DEFAULT,
        SPIFFE,
        KUBERNETES;

    }

    public record OAuthIdentityProviderConfiguration(Mode mode, boolean jwkUse) {
    }
}

