/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.oauth;

import com.sun.net.httpserver.HttpServer;
import org.keycloak.testframework.oauth.KcAdminCallbackHandler;
import org.keycloak.testframework.oauth.KcAdminInvocations;
import org.keycloak.testframework.oauth.OAuthCallbackHandler;

public class TestApp {
    public static final String OAUTH_CALLBACK_PATH = "/callback/oauth";
    public static final String K_ADMIN_PATH = "/k_admin";
    private final HttpServer httpServer;
    private final KcAdminInvocations kcAdminInvocations;
    private final String redirectionUri;
    private final String adminUri;

    public TestApp(HttpServer httpServer) {
        this.httpServer = httpServer;
        this.kcAdminInvocations = new KcAdminInvocations();
        try {
            httpServer.createContext(OAUTH_CALLBACK_PATH, new OAuthCallbackHandler());
            httpServer.createContext(K_ADMIN_PATH, new KcAdminCallbackHandler(this.kcAdminInvocations));
            this.redirectionUri = "http://127.0.0.1:" + httpServer.getAddress().getPort() + OAUTH_CALLBACK_PATH;
            this.adminUri = "http://127.0.0.1:" + httpServer.getAddress().getPort() + K_ADMIN_PATH;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getRedirectionUri() {
        return this.redirectionUri;
    }

    public String getAdminUri() {
        return this.adminUri;
    }

    public KcAdminInvocations kcAdmin() {
        return this.kcAdminInvocations;
    }

    public void close() {
        this.httpServer.removeContext(OAUTH_CALLBACK_PATH);
        this.httpServer.removeContext(K_ADMIN_PATH);
    }
}

