/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.oauth;

import jakarta.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testframework.injection.InstanceContext;
import org.keycloak.testframework.injection.RequestedInstance;
import org.keycloak.testframework.injection.Supplier;
import org.keycloak.testframework.injection.SupplierHelpers;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.TestApp;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testframework.util.ApiUtil;
import org.openqa.selenium.WebDriver;

public class OAuthClientSupplier
implements Supplier<OAuthClient, InjectOAuthClient> {
    public OAuthClient getValue(InstanceContext<OAuthClient, InjectOAuthClient> instanceContext) {
        InjectOAuthClient annotation = (InjectOAuthClient)instanceContext.getAnnotation();
        KeycloakUrls keycloakUrls = (KeycloakUrls)instanceContext.getDependency(KeycloakUrls.class);
        CloseableHttpClient httpClient = (CloseableHttpClient)instanceContext.getDependency(HttpClient.class);
        WebDriver webDriver = (WebDriver)instanceContext.getDependency(WebDriver.class);
        TestApp testApp = (TestApp)instanceContext.getDependency(TestApp.class);
        ManagedRealm realm = (ManagedRealm)instanceContext.getDependency(ManagedRealm.class, annotation.realmRef());
        String redirectUri = testApp.getRedirectionUri();
        ClientConfig clientConfig = (ClientConfig)SupplierHelpers.getInstance(annotation.config());
        ClientRepresentation testAppClient = clientConfig.configure(ClientConfigBuilder.create()).redirectUris(new String[]{redirectUri}).build();
        if (annotation.kcAdmin()) {
            testAppClient.setAdminUrl(testApp.getAdminUri());
        }
        String clientId = testAppClient.getClientId();
        String clientSecret = testAppClient.getSecret();
        ApiUtil.handleCreatedResponse((Response)realm.admin().clients().create(testAppClient));
        OAuthClient oAuthClient = new OAuthClient(keycloakUrls.getBase(), httpClient, webDriver);
        oAuthClient.config().realm(realm.getName()).client(clientId, clientSecret).redirectUri(redirectUri);
        return oAuthClient;
    }

    public boolean compatible(InstanceContext<OAuthClient, InjectOAuthClient> a, RequestedInstance<OAuthClient, InjectOAuthClient> b) {
        return ((InjectOAuthClient)a.getAnnotation()).ref().equals(((InjectOAuthClient)b.getAnnotation()).ref());
    }

    public void close(InstanceContext<OAuthClient, InjectOAuthClient> instanceContext) {
        ((OAuthClient)((Object)instanceContext.getValue())).close();
    }
}

