/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.oauth;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;

public class KcAdminInvocations {
    private final BlockingQueue<LogoutAction> adminLogoutActions = new LinkedBlockingQueue<LogoutAction>();
    private final BlockingQueue<PushNotBeforeAction> adminPushNotBeforeActions = new LinkedBlockingQueue<PushNotBeforeAction>();
    private final BlockingQueue<TestAvailabilityAction> adminTestAvailabilityAction = new LinkedBlockingQueue<TestAvailabilityAction>();

    KcAdminInvocations() {
    }

    public PushNotBeforeAction getAdminPushNotBefore() throws InterruptedException {
        return this.adminPushNotBeforeActions.poll(10L, TimeUnit.SECONDS);
    }

    void add(PushNotBeforeAction action) {
        this.adminPushNotBeforeActions.add(action);
    }

    public TestAvailabilityAction getTestAvailable() throws InterruptedException {
        return this.adminTestAvailabilityAction.poll(10L, TimeUnit.SECONDS);
    }

    void add(TestAvailabilityAction action) {
        this.adminTestAvailabilityAction.add(action);
    }

    public LogoutAction getAdminLogoutAction() throws InterruptedException {
        return this.adminLogoutActions.poll(10L, TimeUnit.SECONDS);
    }

    void add(LogoutAction action) {
        this.adminLogoutActions.add(action);
    }

    public void clear() {
        this.adminLogoutActions.clear();
        this.adminPushNotBeforeActions.clear();
        this.adminTestAvailabilityAction.clear();
    }
}

