/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.oauth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.testframework.oauth.KcAdminInvocations;

public class KcAdminCallbackHandler
implements HttpHandler {
    private final KcAdminInvocations invocations;

    KcAdminCallbackHandler(KcAdminInvocations kcAdminInvocations) {
        this.invocations = kcAdminInvocations;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String path = exchange.getRequestURI().getPath();
        try {
            JWSInput adminToken = new JWSInput(new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8));
            if (path.endsWith("k_logout")) {
                this.invocations.add((LogoutAction)adminToken.readJsonContent(LogoutAction.class));
            } else if (path.endsWith("k_push_not_before")) {
                this.invocations.add((PushNotBeforeAction)adminToken.readJsonContent(PushNotBeforeAction.class));
            } else if (path.endsWith("k_test_available")) {
                this.invocations.add((TestAvailabilityAction)adminToken.readJsonContent(TestAvailabilityAction.class));
            }
            exchange.sendResponseHeaders(204, 0L);
            exchange.close();
        }
        catch (JWSInputException e) {
            throw new IOException(e);
        }
    }
}

