/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework;

import java.util.Optional;
import org.infinispan.util.function.SerializableComparator;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.ClassOrdererContext;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;

public class ServerConfigClassOrderer
implements ClassOrderer {
    public void orderClasses(ClassOrdererContext classOrdererContext) {
        classOrdererContext.getClassDescriptors().sort(new ServerConfigComparator());
    }

    static class ServerConfigComparator
    implements SerializableComparator<ClassDescriptor> {
        ServerConfigComparator() {
        }

        public int compare(ClassDescriptor o1, ClassDescriptor o2) {
            Optional a1 = o1.findAnnotation(KeycloakIntegrationTest.class);
            Optional a2 = o2.findAnnotation(KeycloakIntegrationTest.class);
            if (a1.isPresent() && a2.isPresent()) {
                return ((KeycloakIntegrationTest)a1.get()).config().getName().compareTo(((KeycloakIntegrationTest)a2.get()).config().getName());
            }
            if (a1.isPresent()) {
                return 1;
            }
            if (a2.isPresent()) {
                return 2;
            }
            return 0;
        }
    }
}

