/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationAddHandler;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationDefinition;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationRemoveHandler;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationWriteAttributeHandler;
import org.keycloak.subsystem.adapter.extension.KeycloakHttpAuthenticationFactoryService;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

class KeycloakHttpServerAuthenticationMechanismFactoryDefinition
extends AbstractAdapterConfigurationDefinition {
    static final String TAG_NAME = "http-server-mechanism-factory";

    KeycloakHttpServerAuthenticationMechanismFactoryDefinition() {
        this(TAG_NAME);
    }

    KeycloakHttpServerAuthenticationMechanismFactoryDefinition(String tagName) {
        super(tagName, ALL_ATTRIBUTES, new KeycloakHttpServerAuthenticationMechanismFactoryAddHandler(), new KeycloakHttpServerAuthenticationMechanismFactoryRemoveHandler(), new KeycloakHttpServerAuthenticationMechanismFactoryWriteHandler());
    }

    static final class KeycloakHttpServerAuthenticationMechanismFactoryWriteHandler
    extends AbstractAdapterConfigurationWriteAttributeHandler {
        KeycloakHttpServerAuthenticationMechanismFactoryWriteHandler() {
            super(AbstractAdapterConfigurationDefinition.ALL_ATTRIBUTES);
        }
    }

    static final class KeycloakHttpServerAuthenticationMechanismFactoryRemoveHandler
    extends AbstractAdapterConfigurationRemoveHandler {
        KeycloakHttpServerAuthenticationMechanismFactoryRemoveHandler() {
        }

        @Override
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String factoryName = pathAddress.getLastElement().getValue();
            ServiceName serviceName = context.getCapabilityServiceName("org.wildfly.security.http-server-mechanism-factory", factoryName, HttpServerAuthenticationMechanismFactory.class);
            context.removeService(serviceName);
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.recoverServices(context, operation, model);
            KeycloakHttpServerAuthenticationMechanismFactoryAddHandler.installCapability(context, operation);
        }
    }

    static final class KeycloakHttpServerAuthenticationMechanismFactoryAddHandler
    extends AbstractAdapterConfigurationAddHandler {
        static final String HTTP_SERVER_AUTHENTICATION_CAPABILITY = "org.wildfly.security.http-server-mechanism-factory";
        static final RuntimeCapability<Void> HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.security.http-server-mechanism-factory", (boolean)true, HttpServerAuthenticationMechanismFactory.class).build();

        KeycloakHttpServerAuthenticationMechanismFactoryAddHandler() {
            super(HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY, AbstractAdapterConfigurationDefinition.ALL_ATTRIBUTES);
        }

        @Override
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            KeycloakHttpServerAuthenticationMechanismFactoryAddHandler.installCapability(context, operation);
        }

        static void installCapability(OperationContext context, ModelNode operation) {
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String factoryName = pathAddress.getLastElement().getValue();
            ServiceName serviceName = context.getCapabilityServiceName(HTTP_SERVER_AUTHENTICATION_CAPABILITY, factoryName, HttpServerAuthenticationMechanismFactory.class);
            KeycloakHttpAuthenticationFactoryService service = new KeycloakHttpAuthenticationFactoryService(factoryName);
            context.getServiceTarget().addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

