/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class KeycloakAdapterConfigService
implements Service<KeycloakAdapterConfigService> {
    protected Logger log = Logger.getLogger(KeycloakAdapterConfigService.class);
    private static final String CREDENTIALS_JSON_NAME = "credentials";
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"KeycloakAdapterConfigService"});
    public static final KeycloakAdapterConfigService INSTANCE = new KeycloakAdapterConfigService();
    private Map<String, ModelNode> realms = new HashMap<String, ModelNode>();
    private Map<String, ModelNode> deployments = new HashMap<String, ModelNode>();

    private KeycloakAdapterConfigService() {
    }

    public void start(StartContext sc) throws StartException {
    }

    public void stop(StopContext sc) {
    }

    public KeycloakAdapterConfigService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void addRealm(ModelNode operation, ModelNode model) {
        this.realms.put(this.realmNameFromOp(operation), model.clone());
    }

    public void updateRealm(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode realm = this.realms.get(this.realmNameFromOp(operation));
        realm.get(attrName).set(resolvedValue);
    }

    public void removeRealm(ModelNode operation) {
        this.realms.remove(this.realmNameFromOp(operation));
    }

    public void addSecureDeployment(ModelNode operation, ModelNode model) {
        ModelNode deployment = model.clone();
        this.deployments.put(this.deploymentNameFromOp(operation), deployment);
    }

    public void updateSecureDeployment(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode deployment = this.deployments.get(this.deploymentNameFromOp(operation));
        deployment.get(attrName).set(resolvedValue);
    }

    public void removeSecureDeployment(ModelNode operation) {
        this.deployments.remove(this.deploymentNameFromOp(operation));
    }

    public void addCredential(ModelNode operation, ModelNode model) {
        ModelNode credentials = this.credentialsFromOp(operation);
        if (!credentials.isDefined()) {
            credentials = new ModelNode();
        }
        String credentialName = this.credentialNameFromOp(operation);
        credentials.get(credentialName).set(model.get("value").asString());
        ModelNode deployment = this.deployments.get(this.deploymentNameFromOp(operation));
        deployment.get(CREDENTIALS_JSON_NAME).set(credentials);
    }

    public void removeCredential(ModelNode operation) {
        ModelNode credentials = this.credentialsFromOp(operation);
        if (!credentials.isDefined()) {
            throw new RuntimeException("Can not remove credential.  No credential defined for deployment in op " + operation.toString());
        }
        String credentialName = this.credentialNameFromOp(operation);
        credentials.remove(credentialName);
    }

    public void updateCredential(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode credentials = this.credentialsFromOp(operation);
        if (!credentials.isDefined()) {
            throw new RuntimeException("Can not update credential.  No credential defined for deployment in op " + operation.toString());
        }
        String credentialName = this.credentialNameFromOp(operation);
        credentials.get(credentialName).set(resolvedValue);
    }

    private ModelNode credentialsFromOp(ModelNode operation) {
        ModelNode deployment = this.deployments.get(this.deploymentNameFromOp(operation));
        return deployment.get(CREDENTIALS_JSON_NAME);
    }

    private String realmNameFromOp(ModelNode operation) {
        return this.valueFromOpAddress("realm", operation);
    }

    private String deploymentNameFromOp(ModelNode operation) {
        return this.valueFromOpAddress("secure-deployment", operation);
    }

    private String credentialNameFromOp(ModelNode operation) {
        return this.valueFromOpAddress("credential", operation);
    }

    private String valueFromOpAddress(String addrElement, ModelNode operation) {
        String deploymentName = this.getValueOfAddrElement(operation.get("address"), addrElement);
        if (deploymentName == null) {
            throw new RuntimeException("Can't find '" + addrElement + "' in address " + operation.toString());
        }
        return deploymentName;
    }

    private String getValueOfAddrElement(ModelNode address, String elementName) {
        for (ModelNode element : address.asList()) {
            if (!element.has(elementName)) continue;
            return element.get(elementName).asString();
        }
        return null;
    }

    public String getRealmName(String deploymentName) {
        ModelNode deployment = this.deployments.get(deploymentName);
        return deployment.get("realm").asString();
    }

    public String getJSON(String deploymentName) {
        ModelNode deployment = this.deployments.get(deploymentName);
        String realmName = deployment.get("realm").asString();
        ModelNode realm = this.realms.get(realmName);
        ModelNode json = new ModelNode();
        json.get("realm").set(realmName);
        if (realm != null) {
            this.setJSONValues(json, realm);
        }
        this.setJSONValues(json, deployment);
        return json.toJSONString(true);
    }

    private void setJSONValues(ModelNode json, ModelNode values) {
        for (Property prop : values.asPropertyList()) {
            String name = prop.getName();
            ModelNode value = prop.getValue();
            if (!value.isDefined()) continue;
            json.get(name).set(value);
        }
    }

    public boolean isKeycloakDeployment(String deploymentName) {
        return this.deployments.containsKey(deploymentName);
    }

    static KeycloakAdapterConfigService find(ServiceRegistry registry) {
        ServiceController container = registry.getService(SERVICE_NAME);
        if (container != null) {
            KeycloakAdapterConfigService service = (KeycloakAdapterConfigService)container.getValue();
            return service;
        }
        return null;
    }

    static KeycloakAdapterConfigService find(OperationContext context) {
        return KeycloakAdapterConfigService.find(context.getServiceRegistry(true));
    }
}

