/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension;

import java.util.ArrayList;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.keycloak.subsystem.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.logging.KeycloakLogger;

public class KeycloakAdapterConfigDeploymentProcessor
implements DeploymentUnitProcessor {
    protected Logger log = Logger.getLogger(KeycloakAdapterConfigDeploymentProcessor.class);
    public static final String AUTH_DATA_PARAM_NAME = "org.keycloak.json.adapterConfig";
    public static final Phase PHASE = Phase.INSTALL;
    public static final int PRIORITY = 7423;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        KeycloakAdapterConfigService service = KeycloakAdapterConfigService.find(phaseContext.getServiceRegistry());
        if (service.isKeycloakDeployment(deploymentName)) {
            this.addKeycloakAuthData(phaseContext, deploymentName, service);
        }
    }

    private void addKeycloakAuthData(DeploymentPhaseContext phaseContext, String deploymentName, KeycloakAdapterConfigService service) {
        LoginConfigMetaData loginConfig;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        this.addJSONData(service.getJSON(deploymentName), warMetaData);
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((loginConfig = webMetaData.getLoginConfig()) == null) {
            loginConfig = new LoginConfigMetaData();
            webMetaData.setLoginConfig(loginConfig);
        }
        loginConfig.setAuthMethod("KEYCLOAK");
        loginConfig.setRealmName(service.getRealmName(deploymentName));
        KeycloakLogger.ROOT_LOGGER.deploymentSecured(deploymentName);
    }

    private void addJSONData(String json, WarMetaData warMetaData) {
        ArrayList<ParamValueMetaData> contextParams;
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((contextParams = webMetaData.getContextParams()) == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(AUTH_DATA_PARAM_NAME);
        param.setParamValue(json);
        contextParams.add(param);
        webMetaData.setContextParams(contextParams);
    }

    public void undeploy(DeploymentUnit du) {
    }
}

