/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.keycloak.subsystem.server.extension.KeycloakSubsystemDefinition;
import org.keycloak.subsystem.server.extension.ProviderResourceDefinition;
import org.keycloak.subsystem.server.extension.SpiResourceDefinition;
import org.keycloak.subsystem.server.extension.ThemeResourceDefinition;

public class JsonConfigConverter {
    private static final List<String> NON_SPI_LIST = new ArrayList<String>();

    public static List<ModelNode> convertJsonConfig(String json, PathAddress subsysAddress) throws IOException {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        JsonNode root = new ObjectMapper().readTree(json);
        list.add(JsonConfigConverter.masterRealmName(root, subsysAddress));
        list.add(JsonConfigConverter.scheduledTaskInterval(root, subsysAddress));
        list.add(JsonConfigConverter.providers(root, subsysAddress));
        list.add(JsonConfigConverter.theme(root, subsysAddress.append("theme", "defaults")));
        list.addAll(JsonConfigConverter.spis(root, subsysAddress));
        return list;
    }

    private static ModelNode masterRealmName(JsonNode root, PathAddress addr) {
        JsonNode targetNode = JsonConfigConverter.getNode(root, "admin", "realm");
        String value = KeycloakSubsystemDefinition.MASTER_REALM_NAME.getDefaultValue().asString();
        if (targetNode != null) {
            value = targetNode.asText(value);
        }
        ModelNode op = Util.createOperation((String)"write-attribute", (PathAddress)addr);
        op.get("name").set(KeycloakSubsystemDefinition.MASTER_REALM_NAME.getName());
        op.get("value").set(value);
        return op;
    }

    private static ModelNode scheduledTaskInterval(JsonNode root, PathAddress addr) {
        JsonNode targetNode = JsonConfigConverter.getNode(root, "scheduled", "interval");
        Long value = KeycloakSubsystemDefinition.SCHEDULED_TASK_INTERVAL.getDefaultValue().asLong();
        if (targetNode != null) {
            value = targetNode.asLong(value.longValue());
        }
        ModelNode op = Util.createOperation((String)"write-attribute", (PathAddress)addr);
        op.get("name").set(KeycloakSubsystemDefinition.SCHEDULED_TASK_INTERVAL.getName());
        op.get("value").set(value.longValue());
        return op;
    }

    private static ModelNode providers(JsonNode root, PathAddress addr) {
        JsonNode targetNode = JsonConfigConverter.getNode(root, "providers");
        ModelNode value = KeycloakSubsystemDefinition.PROVIDERS.getDefaultValue();
        if (targetNode != null && targetNode.isArray()) {
            value = new ModelNode();
            for (JsonNode node : targetNode) {
                value.add(node.asText());
            }
        }
        ModelNode op = Util.createOperation((String)"write-attribute", (PathAddress)addr);
        op.get("name").set(KeycloakSubsystemDefinition.PROVIDERS.getName());
        op.get("value").set(value);
        return op;
    }

    private static ModelNode theme(JsonNode root, PathAddress addr) {
        JsonNode themeNode = JsonConfigConverter.getNode(root, "theme");
        ModelNode op = Util.createAddOperation((PathAddress)addr);
        JsonNode targetNode = JsonConfigConverter.getNode(themeNode, "staticMaxAge");
        Long lValue = ThemeResourceDefinition.STATIC_MAX_AGE.getDefaultValue().asLong();
        if (targetNode != null) {
            lValue = targetNode.asLong(lValue.longValue());
        }
        op.get(ThemeResourceDefinition.STATIC_MAX_AGE.getName()).set(lValue.longValue());
        targetNode = JsonConfigConverter.getNode(themeNode, "cacheTemplates");
        Boolean bValue = ThemeResourceDefinition.CACHE_TEMPLATES.getDefaultValue().asBoolean();
        if (targetNode != null) {
            bValue = targetNode.asBoolean(bValue.booleanValue());
        }
        op.get(ThemeResourceDefinition.CACHE_TEMPLATES.getName()).set(bValue.booleanValue());
        targetNode = JsonConfigConverter.getNode(themeNode, "cacheThemes");
        bValue = ThemeResourceDefinition.CACHE_THEMES.getDefaultValue().asBoolean();
        if (targetNode != null) {
            bValue = targetNode.asBoolean(bValue.booleanValue());
        }
        op.get(ThemeResourceDefinition.CACHE_THEMES.getName()).set(bValue.booleanValue());
        targetNode = JsonConfigConverter.getNode(themeNode, "folder", "dir");
        String sValue = ThemeResourceDefinition.DIR.getDefaultValue().asString();
        if (targetNode != null) {
            sValue = targetNode.asText(sValue);
        }
        op.get(ThemeResourceDefinition.DIR.getName()).set(sValue);
        targetNode = JsonConfigConverter.getNode(themeNode, "welcomeTheme");
        if (targetNode != null) {
            op.get(ThemeResourceDefinition.WELCOME_THEME.getName()).set(targetNode.asText());
        }
        if ((targetNode = JsonConfigConverter.getNode(themeNode, "default")) != null) {
            op.get(ThemeResourceDefinition.DEFAULT.getName()).set(targetNode.asText());
        }
        if ((targetNode = JsonConfigConverter.getNode(themeNode, "module", "modules")) != null && targetNode.isArray()) {
            op.get(ThemeResourceDefinition.MODULES.getName()).set(JsonConfigConverter.themeModules(targetNode));
        }
        return op;
    }

    private static ModelNode themeModules(JsonNode modulesNode) {
        ModelNode modules = new ModelNode();
        for (JsonNode node : modulesNode) {
            modules.add(node.asText());
        }
        return modules;
    }

    private static Collection<ModelNode> spis(JsonNode root, PathAddress addr) {
        ArrayList<ModelNode> spis = new ArrayList<ModelNode>();
        Iterator spiIterator = root.fieldNames();
        while (spiIterator.hasNext()) {
            String spiName = (String)spiIterator.next();
            if (NON_SPI_LIST.contains(spiName)) continue;
            PathAddress spiAddr = addr.append("spi", spiName);
            spis.addAll(JsonConfigConverter.spi(root, spiAddr, spiName));
        }
        return spis;
    }

    private static List<ModelNode> spi(JsonNode root, PathAddress spiAddr, String spiName) {
        ArrayList<ModelNode> spiAndProviders = new ArrayList<ModelNode>();
        ModelNode op = Util.createAddOperation((PathAddress)spiAddr);
        spiAndProviders.add(op);
        Iterator providerIterator = root.get(spiName).fieldNames();
        while (providerIterator.hasNext()) {
            String providerName = (String)providerIterator.next();
            if ("provider".equals(providerName)) {
                op.get(SpiResourceDefinition.DEFAULT_PROVIDER.getName()).set(JsonConfigConverter.getNode(root, spiName, "provider").asText());
                continue;
            }
            PathAddress providerAddr = spiAddr.append("provider", providerName);
            spiAndProviders.add(JsonConfigConverter.spiProvider(JsonConfigConverter.getNode(root, spiName, providerName), providerAddr));
        }
        return spiAndProviders;
    }

    private static ModelNode spiProvider(JsonNode providerNode, PathAddress providerAddr) {
        ModelNode op = Util.createAddOperation((PathAddress)providerAddr);
        ModelNode properties = new ModelNode();
        Iterator propNames = providerNode.fieldNames();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            if ("enabled".equals(propName)) {
                op.get(ProviderResourceDefinition.ENABLED.getName()).set(providerNode.get(propName).asBoolean());
                continue;
            }
            if (providerNode.get(propName).isArray()) {
                properties.get(propName).set(JsonConfigConverter.makeArrayText(providerNode.get(propName)));
                continue;
            }
            properties.get(propName).set(providerNode.get(propName).asText());
        }
        if (properties.isDefined() && !properties.asPropertyList().isEmpty()) {
            op.get("properties").set(properties);
        }
        if (!op.hasDefined(ProviderResourceDefinition.ENABLED.getName())) {
            op.get(ProviderResourceDefinition.ENABLED.getName()).set(ProviderResourceDefinition.ENABLED.getDefaultValue());
        }
        return op;
    }

    private static String makeArrayText(JsonNode arrayNode) {
        StringBuilder builder = new StringBuilder("[");
        Iterator nodes = arrayNode.iterator();
        while (nodes.hasNext()) {
            JsonNode node = (JsonNode)nodes.next();
            builder.append("\"");
            builder.append(node.asText());
            builder.append("\"");
            if (!nodes.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private static JsonNode getNode(JsonNode root, String ... path) {
        if (root == null) {
            return null;
        }
        JsonNode n = root;
        for (String p : path) {
            if ((n = n.get(p)) != null) continue;
            return null;
        }
        return n;
    }

    static {
        NON_SPI_LIST.add("providers");
        NON_SPI_LIST.add("admin");
        NON_SPI_LIST.add("theme");
        NON_SPI_LIST.add("scheduled");
    }
}

