/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;
import org.keycloak.authentication.AuthenticatorSpi;
import org.keycloak.authentication.authenticators.browser.DeployedScriptAuthenticatorFactory;
import org.keycloak.authorization.policy.provider.PolicySpi;
import org.keycloak.authorization.policy.provider.js.DeployedScriptPolicyFactory;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.protocol.ProtocolMapperSpi;
import org.keycloak.protocol.oidc.mappers.DeployedScriptOIDCProtocolMapper;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.provider.ScriptProviderDescriptor;
import org.keycloak.representations.provider.ScriptProviderMetadata;
import org.keycloak.util.JsonSerialization;

final class ScriptProviderDeploymentProcessor {
    private static final Map<String, BiConsumer<KeycloakDeploymentInfo, ScriptProviderMetadata>> PROVIDERS = new HashMap<String, BiConsumer<KeycloakDeploymentInfo, ScriptProviderMetadata>>();

    ScriptProviderDeploymentProcessor() {
    }

    private static void registerScriptAuthenticator(KeycloakDeploymentInfo info, ScriptProviderMetadata metadata) {
        info.addProvider(AuthenticatorSpi.class, (ProviderFactory)new DeployedScriptAuthenticatorFactory(metadata));
    }

    private static void registerScriptPolicy(KeycloakDeploymentInfo info, ScriptProviderMetadata metadata) {
        info.addProvider(PolicySpi.class, (ProviderFactory)new DeployedScriptPolicyFactory(metadata));
    }

    private static void registerScriptMapper(KeycloakDeploymentInfo info, ScriptProviderMetadata metadata) {
        info.addProvider(ProtocolMapperSpi.class, (ProviderFactory)new DeployedScriptOIDCProtocolMapper(metadata));
    }

    static void deploy(DeploymentUnit deploymentUnit, KeycloakDeploymentInfo info) {
        ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (resourceRoot == null) {
            return;
        }
        VirtualFile jarFile = resourceRoot.getRoot();
        if (jarFile == null || !jarFile.exists() || !jarFile.getName().endsWith(".jar")) {
            return;
        }
        ScriptProviderDescriptor descriptor = ScriptProviderDeploymentProcessor.readScriptProviderDescriptor(jarFile);
        if (descriptor == null) {
            return;
        }
        for (Map.Entry entry : descriptor.getProviders().entrySet()) {
            for (ScriptProviderMetadata metadata : (List)entry.getValue()) {
                String fileName = metadata.getFileName();
                if (fileName == null) {
                    throw new RuntimeException("You must provide the script file name");
                }
                try (InputStream in = jarFile.getChild(fileName).openStream();){
                    metadata.setCode(StreamUtil.readString((InputStream)in, (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException cause) {
                    throw new RuntimeException("Failed to read script file [" + fileName + "]", cause);
                }
                metadata.setId("script" + "-" + fileName);
                String name = metadata.getName();
                if (name == null) {
                    name = fileName;
                }
                metadata.setName(name);
                PROVIDERS.get(entry.getKey()).accept(info, metadata);
            }
        }
    }

    private static ScriptProviderDescriptor readScriptProviderDescriptor(VirtualFile deploymentRoot) {
        ScriptProviderDescriptor scriptProviderDescriptor;
        block9: {
            VirtualFile metadataFile = deploymentRoot.getChild("META-INF/keycloak-scripts.json");
            if (!metadataFile.exists()) {
                return null;
            }
            InputStream inputStream = metadataFile.openStream();
            try {
                scriptProviderDescriptor = (ScriptProviderDescriptor)JsonSerialization.readValue((InputStream)inputStream, ScriptProviderDescriptor.class);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException cause) {
                    throw new RuntimeException("Failed to read providers metadata", cause);
                }
            }
            inputStream.close();
        }
        return scriptProviderDescriptor;
    }

    static {
        PROVIDERS.put("authenticators", ScriptProviderDeploymentProcessor::registerScriptAuthenticator);
        PROVIDERS.put("policies", ScriptProviderDeploymentProcessor::registerScriptPolicy);
        PROVIDERS.put("mappers", ScriptProviderDeploymentProcessor::registerScriptMapper);
    }
}

