/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.server.extension.KeycloakExtension;
import org.keycloak.subsystem.server.extension.KeycloakSubsystemAdd;
import org.keycloak.subsystem.server.extension.KeycloakSubsystemRemoveHandler;
import org.keycloak.subsystem.server.extension.KeycloakSubsystemWriteAttributeHandler;

public class KeycloakSubsystemDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition WEB_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("web-context", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("auth"))).setRestartAllServices()).build();
    static final List<SimpleAttributeDefinition> ALL_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
    private static final Map<String, SimpleAttributeDefinition> DEFINITION_LOOKUP;
    private static KeycloakSubsystemWriteAttributeHandler attrHandler;

    protected KeycloakSubsystemDefinition() {
        super(KeycloakExtension.PATH_SUBSYSTEM, (ResourceDescriptionResolver)KeycloakExtension.getResourceDescriptionResolver("subsystem"), (OperationStepHandler)KeycloakSubsystemAdd.INSTANCE, (OperationStepHandler)KeycloakSubsystemRemoveHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attributeDefinition : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attributeDefinition, null, (OperationStepHandler)attrHandler);
        }
    }

    public static SimpleAttributeDefinition lookup(String name) {
        return DEFINITION_LOOKUP.get(name);
    }

    static {
        ALL_ATTRIBUTES.add(WEB_CONTEXT);
        DEFINITION_LOOKUP = new HashMap<String, SimpleAttributeDefinition>();
        for (SimpleAttributeDefinition def : ALL_ATTRIBUTES) {
            DEFINITION_LOOKUP.put(def.getXmlName(), def);
        }
        attrHandler = new KeycloakSubsystemWriteAttributeHandler(ALL_ATTRIBUTES);
    }
}

