/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider.wildfly;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.common.util.Resteasy;
import org.keycloak.common.util.SystemEnvProperties;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.util.JsonConfigProviderFactory;
import org.keycloak.util.JsonSerialization;

public class DMRConfigProviderFactory
extends JsonConfigProviderFactory {
    public static final String KEYCLOAK_CONFIG_PARAM_NAME = "org.keycloak.server-subsystem.Config";
    public static final String SERVER_CONTEXT_CONFIG_PROPERTY_OVERRIDES = "keycloak.server.context.config.property-overrides";
    private static final Logger LOG = Logger.getLogger(DMRConfigProviderFactory.class);

    public Optional<Config.ConfigProvider> create() {
        ServletContext context = (ServletContext)Resteasy.getContextData(ServletContext.class);
        JsonNode node = null;
        try {
            String dmrConfig = this.loadDmrConfig(context);
            if (dmrConfig != null) {
                node = JsonSerialization.mapper.readTree(dmrConfig);
                ServicesLogger.LOGGER.loadingFrom((Object)"standalone.xml or domain.xml");
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to load DMR config", (Throwable)e);
        }
        return this.createJsonProvider(node);
    }

    protected Properties getProperties() {
        return new SystemEnvProperties(this.getPropertyOverrides());
    }

    private String loadDmrConfig(ServletContext context) {
        String dmrConfig = context.getInitParameter(KEYCLOAK_CONFIG_PARAM_NAME);
        if (dmrConfig == null) {
            return null;
        }
        ModelNode dmrConfigNode = ModelNode.fromString((String)dmrConfig);
        if (dmrConfigNode.asPropertyList().isEmpty()) {
            return null;
        }
        return dmrConfigNode.resolve().toJSONString(true);
    }

    private Map<String, String> getPropertyOverrides() {
        ServletContext context = (ServletContext)ResteasyProviderFactory.getContextData(ServletContext.class);
        HashMap<String, String> propertyOverridesMap = new HashMap<String, String>();
        String propertyOverrides = context.getInitParameter(SERVER_CONTEXT_CONFIG_PROPERTY_OVERRIDES);
        try {
            if (context.getInitParameter(SERVER_CONTEXT_CONFIG_PROPERTY_OVERRIDES) != null) {
                JsonNode jsonObj = JsonSerialization.mapper.readTree(propertyOverrides);
                jsonObj.fields().forEachRemaining(e -> propertyOverridesMap.put((String)e.getKey(), ((JsonNode)e.getValue()).asText()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return propertyOverridesMap;
    }
}

