/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.CookieTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.elytron.ElytronAccount;
import org.keycloak.adapters.elytron.ElytronHttpFacade;
import org.keycloak.adapters.elytron.ElytronTokeStore;
import org.keycloak.adapters.spi.HttpFacade;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.Scope;

public class ElytronCookieTokenStore
implements ElytronTokeStore {
    protected static Logger log = Logger.getLogger(ElytronCookieTokenStore.class);
    private final ElytronHttpFacade httpFacade;
    private final CallbackHandler callbackHandler;

    public ElytronCookieTokenStore(ElytronHttpFacade httpFacade, CallbackHandler callbackHandler) {
        this.httpFacade = httpFacade;
        this.callbackHandler = callbackHandler;
    }

    public void checkCurrentToken() {
        KeycloakDeployment deployment = this.httpFacade.getDeployment();
        KeycloakPrincipal principal = CookieTokenStore.getPrincipalFromCookie((KeycloakDeployment)deployment, (HttpFacade)this.httpFacade, (AdapterTokenStore)this);
        if (principal == null) {
            return;
        }
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        if (securityContext.isActive() && !securityContext.getDeployment().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = securityContext.refreshExpiredToken(false);
        if (success && securityContext.isActive()) {
            return;
        }
        this.saveAccountInfo(new ElytronAccount((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal));
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        KeycloakDeployment deployment = this.httpFacade.getDeployment();
        KeycloakPrincipal principal = CookieTokenStore.getPrincipalFromCookie((KeycloakDeployment)deployment, (HttpFacade)this.httpFacade, (AdapterTokenStore)this);
        if (principal == null) {
            log.debug((Object)"Account was not in cookie or was invalid, returning null");
            return false;
        }
        ElytronAccount account = new ElytronAccount((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal);
        if (!deployment.getRealm().equals(account.getKeycloakSecurityContext().getRealm())) {
            log.debug((Object)"Account in session belongs to a different realm than for this request.");
            return false;
        }
        boolean active = account.checkActive();
        if (!active) {
            active = account.tryRefresh();
        }
        if (active) {
            log.debug((Object)"Cached account found");
            this.restoreRequest();
            this.httpFacade.authenticationComplete(account, true);
            return true;
        }
        log.debug((Object)"Account was not active, removing cookie and returning false");
        CookieTokenStore.removeCookie((KeycloakDeployment)deployment, (HttpFacade)this.httpFacade);
        return false;
    }

    public void saveAccountInfo(OidcKeycloakAccount account) {
        RefreshableKeycloakSecurityContext secContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.httpFacade.getDeployment(), (HttpFacade)this.httpFacade, (RefreshableKeycloakSecurityContext)secContext);
        HttpScope exchange = this.httpFacade.getScope(Scope.EXCHANGE);
        exchange.registerForNotification(httpServerScopes -> this.logout());
        exchange.setAttachment(ElytronAccount.class.getName(), (Object)account);
        exchange.setAttachment(KeycloakSecurityContext.class.getName(), (Object)account.getKeycloakSecurityContext());
        this.restoreRequest();
    }

    public void logout() {
        this.logout(false);
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.httpFacade.getDeployment(), (HttpFacade)this.httpFacade, (RefreshableKeycloakSecurityContext)securityContext);
    }

    public void saveRequest() {
    }

    public boolean restoreRequest() {
        return false;
    }

    @Override
    public void logout(boolean glo) {
        KeycloakPrincipal principal = CookieTokenStore.getPrincipalFromCookie((KeycloakDeployment)this.httpFacade.getDeployment(), (HttpFacade)this.httpFacade, (AdapterTokenStore)this);
        if (principal == null) {
            return;
        }
        CookieTokenStore.removeCookie((KeycloakDeployment)this.httpFacade.getDeployment(), (HttpFacade)this.httpFacade);
        if (glo) {
            KeycloakSecurityContext ksc = principal.getKeycloakSecurityContext();
            if (ksc == null) {
                return;
            }
            KeycloakDeployment deployment = this.httpFacade.getDeployment();
            if (!deployment.isBearerOnly() && ksc != null && ksc instanceof RefreshableKeycloakSecurityContext) {
                ((RefreshableKeycloakSecurityContext)ksc).logout(deployment);
            }
        }
    }
}

