/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.elytron.ElytronHttpFacade;
import org.keycloak.adapters.elytron.ElytronRequestAuthenticator;
import org.keycloak.adapters.elytron.KeycloakConfigurationServletListener;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.Scope;

class KeycloakHttpServerAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    static Logger LOGGER = Logger.getLogger(KeycloakHttpServerAuthenticationMechanism.class);
    static final String NAME = "KEYCLOAK";
    private final Map<String, ?> properties;
    private final CallbackHandler callbackHandler;
    private final AdapterDeploymentContext deploymentContext;
    private final NodesRegistrationManagement nodesRegistrationManagement;

    public KeycloakHttpServerAuthenticationMechanism(Map<String, ?> properties, CallbackHandler callbackHandler, AdapterDeploymentContext deploymentContext, NodesRegistrationManagement nodesRegistrationManagement) {
        this.properties = properties;
        this.callbackHandler = callbackHandler;
        this.deploymentContext = deploymentContext;
        this.nodesRegistrationManagement = nodesRegistrationManagement;
    }

    public String getMechanismName() {
        return NAME;
    }

    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        LOGGER.debugf("Evaluating request for path [%s]", (Object)request.getRequestURI());
        AdapterDeploymentContext deploymentContext = this.getDeploymentContext(request);
        if (deploymentContext == null) {
            LOGGER.debugf("Ignoring request for path [%s] from mechanism [%s]. No deployment context found.", (Object)request.getRequestURI(), (Object)this.getMechanismName());
            request.noAuthenticationInProgress();
            return;
        }
        ElytronHttpFacade httpFacade = new ElytronHttpFacade(request, deploymentContext, this.callbackHandler);
        KeycloakDeployment deployment = httpFacade.getDeployment();
        if (!deployment.isConfigured()) {
            request.noAuthenticationInProgress();
            return;
        }
        ElytronRequestAuthenticator authenticator = this.createRequestAuthenticator(request, httpFacade, deployment);
        httpFacade.getTokenStore().checkCurrentToken();
        if (this.preActions(httpFacade, deploymentContext)) {
            LOGGER.debugf("Pre-actions has aborted the evaluation of [%s]", (Object)request.getRequestURI());
            httpFacade.authenticationInProgress();
            return;
        }
        AuthOutcome outcome = authenticator.authenticate();
        if (AuthOutcome.AUTHENTICATED.equals((Object)outcome)) {
            if (new AuthenticatedActionsHandler(deployment, (OIDCHttpFacade)httpFacade).handledRequest()) {
                httpFacade.authenticationInProgress();
            } else {
                httpFacade.authenticationComplete();
            }
            return;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            httpFacade.noAuthenticationInProgress(challenge);
            return;
        }
        if (AuthOutcome.FAILED.equals((Object)outcome)) {
            httpFacade.getResponse().setStatus(403);
            httpFacade.authenticationFailed();
            return;
        }
        httpFacade.noAuthenticationInProgress();
    }

    private ElytronRequestAuthenticator createRequestAuthenticator(HttpServerRequest request, ElytronHttpFacade httpFacade, KeycloakDeployment deployment) {
        return new ElytronRequestAuthenticator(this.callbackHandler, httpFacade, deployment, this.getConfidentialPort(request));
    }

    private AdapterDeploymentContext getDeploymentContext(HttpServerRequest request) {
        if (this.deploymentContext == null) {
            return (AdapterDeploymentContext)request.getScope(Scope.APPLICATION).getAttachment(KeycloakConfigurationServletListener.ADAPTER_DEPLOYMENT_CONTEXT_ATTRIBUTE_ELYTRON);
        }
        return this.deploymentContext;
    }

    private boolean preActions(ElytronHttpFacade httpFacade, AdapterDeploymentContext deploymentContext) {
        this.nodesRegistrationManagement.tryRegister(httpFacade.getDeployment());
        PreAuthActionsHandler preActions = new PreAuthActionsHandler((UserSessionManagement)UserSessionManagement.class.cast(httpFacade.getTokenStore()), deploymentContext, (HttpFacade)httpFacade);
        return preActions.handleRequest();
    }

    private int getConfidentialPort(HttpServerRequest request) {
        return 8443;
    }
}

