/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.elytron.ElytronAccount;
import org.keycloak.adapters.elytron.ElytronHttpFacade;
import org.keycloak.adapters.elytron.ElytronTokeStore;
import org.keycloak.adapters.elytron.ProtectedHttpServerExchange;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.keycloak.representations.AccessToken;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.Scope;

public class ElytronSessionTokenStore
implements ElytronTokeStore,
UserSessionManagement {
    private static Logger log = Logger.getLogger(ElytronSessionTokenStore.class);
    private final ElytronHttpFacade httpFacade;
    private final CallbackHandler callbackHandler;

    public ElytronSessionTokenStore(ElytronHttpFacade httpFacade, CallbackHandler callbackHandler) {
        this.httpFacade = httpFacade;
        this.callbackHandler = callbackHandler;
    }

    public void checkCurrentToken() {
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (session == null || !session.exists()) {
            return;
        }
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)session.getAttachment(KeycloakSecurityContext.class.getName());
        if (securityContext == null) {
            return;
        }
        if (securityContext.getDeployment() == null) {
            securityContext.setCurrentRequestInfo(this.httpFacade.getDeployment(), (AdapterTokenStore)this);
        }
        if (securityContext.isActive() && !securityContext.getDeployment().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = securityContext.refreshExpiredToken(false);
        if (success && securityContext.isActive()) {
            return;
        }
        session.setAttachment(KeycloakSecurityContext.class.getName(), null);
        session.invalidate();
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        ElytronAccount account;
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (session == null || !session.supportsAttachments()) {
            log.debug((Object)"session was null, returning null");
            return false;
        }
        try {
            account = (ElytronAccount)session.getAttachment(ElytronAccount.class.getName());
        }
        catch (IllegalStateException e) {
            log.debug((Object)"session was invalidated.  Return false.");
            return false;
        }
        if (account == null) {
            log.debug((Object)"Account was not in session, returning null");
            return false;
        }
        KeycloakDeployment deployment = this.httpFacade.getDeployment();
        if (!deployment.getRealm().equals(account.getKeycloakSecurityContext().getRealm())) {
            log.debug((Object)"Account in session belongs to a different realm than for this request.");
            return false;
        }
        boolean active = account.checkActive();
        if (!active) {
            active = account.tryRefresh();
        }
        if (active) {
            log.debug((Object)"Cached account found");
            this.restoreRequest();
            this.httpFacade.authenticationComplete(account, true);
            return true;
        }
        log.debug((Object)"Refresh failed. Account was not active. Returning null and invalidating Http session");
        try {
            session.setAttachment(KeycloakSecurityContext.class.getName(), null);
            session.setAttachment(ElytronAccount.class.getName(), null);
            session.invalidate();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to invalidate session, might already be invalidated");
        }
        return false;
    }

    public void saveAccountInfo(OidcKeycloakAccount account) {
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (!session.exists()) {
            session.create();
            session.registerForNotification(httpScopeNotification -> {
                HttpScope invalidated;
                if (!httpScopeNotification.isOfType(new Enum[]{HttpScopeNotification.SessionNotificationType.UNDEPLOY}) && (invalidated = httpScopeNotification.getScope(Scope.SESSION)) != null) {
                    invalidated.setAttachment(ElytronAccount.class.getName(), null);
                    invalidated.setAttachment(KeycloakSecurityContext.class.getName(), null);
                }
            });
        }
        session.setAttachment(ElytronAccount.class.getName(), (Object)account);
        session.setAttachment(KeycloakSecurityContext.class.getName(), (Object)account.getKeycloakSecurityContext());
        HttpScope scope = this.httpFacade.getScope(Scope.EXCHANGE);
        scope.setAttachment(KeycloakSecurityContext.class.getName(), (Object)account.getKeycloakSecurityContext());
    }

    public void logout() {
        this.logout(false);
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
        KeycloakPrincipal principal = new KeycloakPrincipal(AdapterUtils.getPrincipalName((KeycloakDeployment)this.httpFacade.getDeployment(), (AccessToken)securityContext.getToken()), (KeycloakSecurityContext)securityContext);
        this.saveAccountInfo(new ElytronAccount((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal));
    }

    public void saveRequest() {
        this.httpFacade.suspendRequest();
    }

    public boolean restoreRequest() {
        return this.httpFacade.restoreRequest();
    }

    @Override
    public void logout(boolean glo) {
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (!session.exists()) {
            return;
        }
        KeycloakSecurityContext ksc = (KeycloakSecurityContext)session.getAttachment(KeycloakSecurityContext.class.getName());
        try {
            if (glo && ksc != null) {
                KeycloakDeployment deployment = this.httpFacade.getDeployment();
                session.invalidate();
                if (!deployment.isBearerOnly() && ksc != null && ksc instanceof RefreshableKeycloakSecurityContext) {
                    ((RefreshableKeycloakSecurityContext)ksc).logout(deployment);
                }
            } else {
                session.setAttachment(ElytronAccount.class.getName(), null);
                session.setAttachment(KeycloakSecurityContext.class.getName(), null);
            }
        }
        catch (IllegalStateException ise) {
            log.debugf("Session %s logged-out already", (Object)session.getID());
        }
    }

    public void logoutAll() {
        Collection<String> sessions = this.httpFacade.getScopeIds(Scope.SESSION);
        this.logoutHttpSessions(new ArrayList<String>(sessions));
    }

    public void logoutHttpSessions(List<String> ids) {
        HttpServerExchange exchange = ((ProtectedHttpServerExchange)ProtectedHttpServerExchange.class.cast(this.httpFacade.getScope(Scope.EXCHANGE).getAttachment(ElytronHttpFacade.UNDERTOW_EXCHANGE))).getExchange();
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        SessionManager sessionManager = servletRequestContext.getDeployment().getSessionManager();
        boolean isDistributableSessionManager = sessionManager.getClass().getName().equals("org.wildfly.clustering.web.undertow.session.DistributableSessionManager");
        for (final String id : ids) {
            Session session = isDistributableSessionManager ? sessionManager.getSession(exchange, new SessionConfig(){

                public void setSessionId(HttpServerExchange exchange, String sessionId) {
                }

                public void clearSession(HttpServerExchange exchange, String sessionId) {
                }

                public String findSessionId(HttpServerExchange exchange) {
                    return id;
                }

                public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
                    return null;
                }

                public String rewriteUrl(String originalUrl, String sessionId) {
                    return null;
                }
            }) : sessionManager.getSession(id);
            if (session == null) continue;
            session.invalidate(exchange);
        }
    }
}

