/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.wildfly.adduser;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.cl.parser.ParserGenerator;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandNotFoundException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.command.registry.AeshCommandRegistryBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.keycloak.common.util.Base64;
import org.keycloak.hash.Pbkdf2PasswordHashProvider;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.util.JsonSerialization;

public class AddUser {
    private static final String COMMAND_NAME = "add-user";
    private static final int DEFAULT_HASH_ITERATIONS = 100000;

    public static void main(String[] args) throws Exception {
        AddUserCommand command = new AddUserCommand();
        try {
            ParserGenerator.parseAndPopulate((Command)command, (String)COMMAND_NAME, (String[])args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        if (command.isContainer()) {
            LinkedList<String> l = new LinkedList<String>(Arrays.asList(args));
            l.remove("--container");
            args = l.toArray(new String[l.size()]);
            org.jboss.as.domain.management.security.adduser.AddUser.main((String[])args);
        } else if (command.isHelp()) {
            AddUser.printHelp(command);
        } else {
            try {
                AddUser.checkRequired(command, "user");
                AddUser.checkRequired(command, "password");
                File addUserFile = AddUser.getAddUserFile(command);
                AddUser.createUser(addUserFile, command.getRealm(), command.getUser(), command.getPassword(), command.getRoles(), command.getIterations());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getAddUserFile(AddUserCommand command) throws Exception {
        File configDir;
        if (command.isDomain()) {
            if (command.getDc() != null) {
                configDir = new File(command.getDc());
            } else if (System.getProperty("jboss.domain.config.user.dir") != null) {
                configDir = new File(System.getProperty("jboss.domain.config.user.dir"));
            } else {
                if (System.getenv("JBOSS_HOME") == null) throw new Exception("Could not find domain configuration directory");
                configDir = new File(System.getenv("JBOSS_HOME") + File.separator + "domain" + File.separator + "configuration");
            }
        } else if (command.getSc() != null) {
            configDir = new File(command.getSc());
        } else if (System.getProperty("jboss.server.config.user.dir") != null) {
            configDir = new File(System.getProperty("jboss.server.config.user.dir"));
        } else {
            if (System.getenv("JBOSS_HOME") == null) throw new Exception("Could not find standalone configuration directory");
            configDir = new File(System.getenv("JBOSS_HOME") + File.separator + "standalone" + File.separator + "configuration");
        }
        if (configDir.isDirectory()) return new File(configDir, "keycloak-add-user.json");
        throw new Exception("'" + configDir + "' does not exist or is not a directory");
    }

    private static void createUser(File addUserFile, String realmName, String userName, String password, String rolesString, int iterations) throws Exception {
        List realms = addUserFile.isFile() ? (List)JsonSerialization.readValue((InputStream)new FileInputStream(addUserFile), (TypeReference)new TypeReference<List<RealmRepresentation>>(){}) : new LinkedList();
        if (realmName == null) {
            realmName = "master";
        }
        RealmRepresentation realm = null;
        for (RealmRepresentation r : realms) {
            if (!r.getRealm().equals(realmName)) continue;
            realm = r;
        }
        if (realm == null) {
            realm = new RealmRepresentation();
            realm.setRealm(realmName);
            realms.add(realm);
            realm.setUsers(new LinkedList());
        }
        for (UserRepresentation u : realm.getUsers()) {
            if (!u.getUsername().equals(userName)) continue;
            throw new Exception("User with username '" + userName + "' already added to '" + addUserFile + "'");
        }
        UserRepresentation user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername(userName);
        user.setCredentials(new LinkedList());
        UserCredentialValueModel credentialValueModel = new Pbkdf2PasswordHashProvider().encode(password, iterations > 0 ? iterations : 100000);
        CredentialRepresentation credentials = new CredentialRepresentation();
        credentials.setType(credentialValueModel.getType());
        credentials.setAlgorithm(credentialValueModel.getAlgorithm());
        credentials.setHashIterations(Integer.valueOf(credentialValueModel.getHashIterations()));
        credentials.setSalt(Base64.encodeBytes((byte[])credentialValueModel.getSalt()));
        credentials.setHashedSaltedValue(credentialValueModel.getValue());
        user.getCredentials().add(credentials);
        String[] roles = rolesString != null ? rolesString.split(",") : (realmName.equals("master") ? new String[]{"admin"} : new String[]{"realm-management/realm-admin"});
        for (String r : roles) {
            if (r.indexOf(47) != -1) {
                String[] cr = r.split("/");
                String client = cr[0];
                String clientRole = cr[1];
                if (user.getClientRoles() == null) {
                    user.setClientRoles(new HashMap());
                }
                if (user.getClientRoles().get(client) == null) {
                    user.getClientRoles().put(client, new LinkedList());
                }
                ((List)user.getClientRoles().get(client)).add(clientRole);
                continue;
            }
            if (user.getRealmRoles() == null) {
                user.setRealmRoles(new LinkedList());
            }
            user.getRealmRoles().add(r);
        }
        realm.getUsers().add(user);
        JsonSerialization.writeValuePrettyToStream((OutputStream)new FileOutputStream(addUserFile), realms);
        System.out.println("Added '" + userName + "' to '" + addUserFile + "', restart server to load user");
    }

    private static void checkRequired(Command command, String field) throws Exception {
        Method m = command.getClass().getMethod("get" + Character.toUpperCase(field.charAt(0)) + field.substring(1), new Class[0]);
        if (m.invoke((Object)command, new Object[0]) == null) {
            Option option = command.getClass().getDeclaredField(field).getAnnotation(Option.class);
            String optionName = option != null && option.shortName() != '\u0000' ? "-" + option.shortName() + ", --" + field : "--" + field;
            throw new Exception("Option: " + optionName + " is required");
        }
    }

    private static void printHelp(Command command) throws CommandNotFoundException {
        CommandRegistry registry = new AeshCommandRegistryBuilder().command(command).create();
        CommandContainer commandContainer = registry.getCommand(command.getClass().getAnnotation(CommandDefinition.class).name(), null);
        String help = commandContainer.printHelp(null);
        System.out.println(help);
    }

    @CommandDefinition(name="add-user", description="[options...]")
    public static class AddUserCommand
    implements Command {
        @Option(shortName=114, hasValue=true, description="Name of realm to add user to")
        private String realm;
        @Option(shortName=117, hasValue=true, description="Name of the user")
        private String user;
        @Option(shortName=112, hasValue=true, description="Password of the user")
        private String password;
        @Option(hasValue=true, description="Roles to add to the user")
        private String roles;
        @Option(hasValue=true, description="Hash iterations")
        private int iterations;
        @Option(hasValue=false, description="Enable domain mode")
        private boolean domain;
        @Option(hasValue=false, description="Add user to underlying container. For usage use '--container --help'")
        private boolean container;
        @Option(hasValue=true, description="Define the location of the server config directory")
        private String sc;
        @Option(hasValue=true, description="Define the location of the domain config directory")
        private String dc;
        @Option(shortName=104, hasValue=false, description="Display this help and exit")
        private boolean help;

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            return CommandResult.SUCCESS;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getRoles() {
            return this.roles;
        }

        public int getIterations() {
            return this.iterations;
        }

        public boolean isDomain() {
            return this.domain;
        }

        public boolean isContainer() {
            return this.container;
        }

        public String getSc() {
            return this.sc;
        }

        public String getDc() {
            return this.dc;
        }

        public boolean isHelp() {
            return this.help;
        }
    }
}

