/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class ServerUtil {
    private static final ModuleIdentifier KEYCLOAK_SUBSYSTEM = ModuleIdentifier.create((String)"org.keycloak.keycloak-server-subsystem");
    private final String deploymentName;
    private final Module subsysModule;
    private final String keycloakVersion;
    private final boolean isServerWarExploded;
    private final URI serverWar;

    ServerUtil(ModelNode operation) {
        this.deploymentName = ServerUtil.getDeploymentName(operation);
        this.subsysModule = this.findSubsysModule();
        this.keycloakVersion = this.subsysModule.getProperty("keycloak-version");
        this.isServerWarExploded = Boolean.parseBoolean(this.subsysModule.getProperty("server-war-exploded"));
        this.serverWar = this.findServerWarUri();
    }

    private Module findSubsysModule() {
        try {
            return Module.getModuleFromCallerModuleLoader((ModuleIdentifier)KEYCLOAK_SUBSYSTEM);
        }
        catch (ModuleLoadException e) {
            throw new IllegalStateException("Can't find Keycloak subsystem.", e);
        }
    }

    private URI findServerWarUri() throws IllegalStateException {
        try {
            URL subsysResource = this.subsysModule.getExportedResource("module.xml");
            File subsysDir = new File(subsysResource.toURI()).getParentFile();
            File serverWarDir = new File(subsysDir, "server-war");
            if (this.isServerWarExploded) {
                return serverWarDir.toURI();
            }
            return new File(serverWarDir, "keycloak-server-" + this.keycloakVersion + ".war").toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    void addStepToUploadServerWar(OperationContext context) throws OperationFailedException {
        PathAddress deploymentAddress = ServerUtil.deploymentAddress(this.deploymentName);
        ModelNode op = Util.createOperation((String)"add", (PathAddress)deploymentAddress);
        op.get("enabled").set(true);
        op.get("persistent").set(false);
        op.get("owner").set(new ModelNode().add("subsystem", "keycloak-server"));
        if (this.serverWar == null) {
            throw new OperationFailedException("Keycloak Server WAR not found in keycloak-server-subsystem module");
        }
        op.get("content").add(this.makeContentItem());
        context.addStep(op, ServerUtil.getHandler(context, deploymentAddress, "add"), OperationContext.Stage.MODEL);
    }

    private ModelNode makeContentItem() throws OperationFailedException {
        ModelNode contentItem = new ModelNode();
        if (this.isServerWarExploded) {
            String urlString = new File(this.serverWar).getAbsolutePath();
            contentItem.get("path").set(urlString);
            contentItem.get("archive").set(false);
        } else {
            String urlString = this.serverWar.toString();
            contentItem.get("url").set(urlString);
        }
        return contentItem;
    }

    static void addStepToRedeployServerWar(OperationContext context, String deploymentName) {
        ServerUtil.addDeploymentAction(context, "redeploy", deploymentName);
    }

    private static void addDeploymentAction(OperationContext context, String operation, String deploymentName) {
        if (!context.isNormalServer()) {
            return;
        }
        PathAddress deploymentAddress = ServerUtil.deploymentAddress(deploymentName);
        ModelNode op = Util.createOperation((String)operation, (PathAddress)deploymentAddress);
        op.get("runtime-name").set(deploymentName);
        context.addStep(op, ServerUtil.getHandler(context, deploymentAddress, operation), OperationContext.Stage.MODEL);
    }

    private static PathAddress deploymentAddress(String deploymentName) {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)deploymentName)});
    }

    static OperationStepHandler getHandler(OperationContext context, PathAddress address, String opName) {
        ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
        return rootResourceRegistration.getOperationHandler(address, opName);
    }

    static String getDeploymentName(ModelNode operation) {
        String deploymentName = Util.getNameFromAddress((ModelNode)operation.get("address"));
        if (!deploymentName.toLowerCase().endsWith(".war")) {
            deploymentName = deploymentName + ".war";
        }
        return deploymentName;
    }
}

