/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util.ldap;

import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.JdbmPartitionFactory;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.extended.PwdModifyHandler;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.common.util.FindFile;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.util.ldap.JdbmPartitionFactoryFast;
import org.keycloak.util.ldap.RangedAttributeInterceptor;

public class LDAPEmbeddedServer {
    private static final Logger log = Logger.getLogger(LDAPEmbeddedServer.class);
    private static final int PAGE_SIZE = 30;
    public static final String PROPERTY_BASE_DN = "ldap.baseDN";
    public static final String PROPERTY_BIND_HOST = "ldap.host";
    public static final String PROPERTY_BIND_PORT = "ldap.port";
    public static final String PROPERTY_BIND_LDAPS_PORT = "ldaps.port";
    public static final String PROPERTY_LDIF_FILE = "ldap.ldif";
    public static final String PROPERTY_SASL_PRINCIPAL = "ldap.saslPrincipal";
    public static final String PROPERTY_DSF = "ldap.dsf";
    public static final String PROPERTY_ENABLE_ACCESS_CONTROL = "enableAccessControl";
    public static final String PROPERTY_ENABLE_ANONYMOUS_ACCESS = "enableAnonymousAccess";
    public static final String PROPERTY_ENABLE_SSL = "enableSSL";
    public static final String PROPERTY_ENABLE_STARTTLS = "enableStartTLS";
    public static final String PROPERTY_SET_CONFIDENTIALITY_REQUIRED = "setConfidentialityRequired";
    private static final String DEFAULT_BASE_DN = "dc=keycloak,dc=org";
    private static final String DEFAULT_BIND_HOST = "localhost";
    private static final String DEFAULT_BIND_PORT = "10389";
    private static final String DEFAULT_BIND_LDAPS_PORT = "10636";
    private static final String DEFAULT_LDIF_FILE = "classpath:ldap/default-users.ldif";
    private static final String PROPERTY_KEYSTORE_FILE = "keystoreFile";
    private static final String PROPERTY_CERTIFICATE_PASSWORD = "certificatePassword";
    public static final String DSF_INMEMORY = "mem";
    public static final String DSF_FILE = "file";
    public static final String DEFAULT_DSF = "file";
    protected Properties defaultProperties;
    protected String baseDN;
    protected String bindHost;
    protected int bindPort;
    protected int bindLdapsPort;
    protected String ldifFile;
    protected String ldapSaslPrincipal;
    protected String directoryServiceFactory;
    protected boolean enableAccessControl = false;
    protected boolean enableAnonymousAccess = false;
    protected boolean enableSSL = false;
    protected boolean enableStartTLS = false;
    protected boolean setConfidentialityRequired = false;
    protected String keystoreFile;
    protected String certPassword;
    protected DirectoryService directoryService;
    protected LdapServer ldapServer;

    public int getBindPort() {
        return this.bindPort;
    }

    public int getBindLdapsPort() {
        return this.bindLdapsPort;
    }

    public static void main(String[] args) throws Exception {
        Properties defaultProperties = new Properties();
        defaultProperties.put(PROPERTY_DSF, "file");
        LDAPEmbeddedServer.execute(args, defaultProperties);
    }

    public static void execute(String[] args, Properties defaultProperties) throws Exception {
        final LDAPEmbeddedServer ldapEmbeddedServer = new LDAPEmbeddedServer(defaultProperties);
        ldapEmbeddedServer.init();
        ldapEmbeddedServer.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    ldapEmbeddedServer.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public LDAPEmbeddedServer(Properties defaultProperties) {
        this.defaultProperties = defaultProperties;
        this.baseDN = this.readProperty(PROPERTY_BASE_DN, DEFAULT_BASE_DN);
        this.bindHost = this.readProperty(PROPERTY_BIND_HOST, DEFAULT_BIND_HOST);
        String bindPort = this.readProperty(PROPERTY_BIND_PORT, DEFAULT_BIND_PORT);
        this.bindPort = Integer.parseInt(bindPort);
        String bindLdapsPort = this.readProperty(PROPERTY_BIND_LDAPS_PORT, DEFAULT_BIND_LDAPS_PORT);
        this.bindLdapsPort = Integer.parseInt(bindLdapsPort);
        this.ldifFile = this.readProperty(PROPERTY_LDIF_FILE, DEFAULT_LDIF_FILE);
        this.ldapSaslPrincipal = this.readProperty(PROPERTY_SASL_PRINCIPAL, null);
        this.directoryServiceFactory = this.readProperty(PROPERTY_DSF, "file");
        this.enableAccessControl = Boolean.valueOf(this.readProperty(PROPERTY_ENABLE_ACCESS_CONTROL, "false"));
        this.enableAnonymousAccess = Boolean.valueOf(this.readProperty(PROPERTY_ENABLE_ANONYMOUS_ACCESS, "false"));
        this.enableSSL = Boolean.valueOf(this.readProperty(PROPERTY_ENABLE_SSL, "false"));
        this.enableStartTLS = Boolean.valueOf(this.readProperty(PROPERTY_ENABLE_STARTTLS, "false"));
        this.setConfidentialityRequired = Boolean.valueOf(this.readProperty(PROPERTY_SET_CONFIDENTIALITY_REQUIRED, "false"));
        this.keystoreFile = this.readProperty(PROPERTY_KEYSTORE_FILE, null);
        this.certPassword = this.readProperty(PROPERTY_CERTIFICATE_PASSWORD, null);
    }

    protected String readProperty(String propertyName, String defaultValue) {
        String value = System.getProperty(propertyName);
        if (value == null || value.isEmpty()) {
            value = (String)this.defaultProperties.get(propertyName);
        }
        if (value == null || value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    public void init() throws Exception {
        log.info((Object)("Creating LDAP Directory Service. Config: baseDN=" + this.baseDN + ", bindHost=" + this.bindHost + ", bindPort=" + this.bindPort + ", ldapSaslPrincipal=" + this.ldapSaslPrincipal + ", directoryServiceFactory=" + this.directoryServiceFactory + ", ldif=" + this.ldifFile + ", enableSSL=" + this.enableSSL + ", enableStartTLS: " + this.enableStartTLS + ", keystoreFile: " + this.keystoreFile + ", default java keystore type: " + KeyStore.getDefaultType()));
        this.directoryService = this.createDirectoryService();
        log.info((Object)("Importing LDIF: " + this.ldifFile));
        this.importLdif();
        log.info((Object)"Creating LDAP server..");
        this.ldapServer = this.createLdapServer();
    }

    public void start() throws Exception {
        log.info((Object)"Starting LDAP server..");
        this.ldapServer.start();
        if (this.ldapServer.isStarted() && this.ldapServer.getDirectoryService().isStarted()) {
            log.info((Object)"LDAP server started.");
        } else {
            if (!this.ldapServer.isStarted()) {
                throw new RuntimeException("Failed to start the LDAP server!");
            }
            if (!this.ldapServer.getDirectoryService().isStarted()) {
                throw new RuntimeException("Failed to start the directory service for the LDAP server!");
            }
        }
    }

    protected DirectoryService createDirectoryService() throws Exception {
        String dcName = this.baseDN.split(",")[0];
        dcName = dcName.substring(dcName.indexOf("=") + 1);
        if (this.directoryServiceFactory.equals(DSF_INMEMORY)) {
            System.setProperty("apacheds.partition.factory", JdbmPartitionFactoryFast.class.getName());
        } else if (this.directoryServiceFactory.equals("file")) {
            System.setProperty("apacheds.partition.factory", JdbmPartitionFactory.class.getName());
        } else {
            throw new IllegalStateException("Unknown value of directoryServiceFactory: " + this.directoryServiceFactory);
        }
        DefaultDirectoryServiceFactory dsf = new DefaultDirectoryServiceFactory();
        DirectoryService service = dsf.getDirectoryService();
        service.setAccessControlEnabled(this.enableAccessControl);
        service.setAllowAnonymousAccess(this.enableAnonymousAccess);
        service.getChangeLog().setEnabled(false);
        dsf.init(dcName + "DS");
        Partition partition = dsf.getPartitionFactory().createPartition(service.getSchemaManager(), service.getDnFactory(), dcName, this.baseDN, 1000, new File(service.getInstanceLayout().getPartitionsDirectory(), dcName));
        partition.initialize();
        partition.setSchemaManager(service.getSchemaManager());
        service.addPartition(partition);
        String entryLdif = "dn: " + this.baseDN + "\ndc: " + dcName + "\nobjectClass: top\nobjectClass: domain\n\n";
        LDAPEmbeddedServer.importLdifContent(service, entryLdif);
        if (this.directoryServiceFactory.equals(DSF_INMEMORY)) {
            List interceptors = service.getInterceptors();
            int insertionPosition = -1;
            for (int pos = 0; pos < interceptors.size(); ++pos) {
                Interceptor interceptor = (Interceptor)interceptors.get(pos);
                if (!(interceptor instanceof NormalizationInterceptor)) continue;
                insertionPosition = pos;
            }
            RangedAttributeInterceptor interceptor = new RangedAttributeInterceptor("member", 30);
            interceptor.init(service);
            interceptors.add(insertionPosition + 1, interceptor);
            service.setInterceptors(interceptors);
        }
        return service;
    }

    protected LdapServer createLdapServer() {
        LdapServer ldapServer = new LdapServer();
        ldapServer.setServiceName("DefaultLdapServer");
        ldapServer.setSearchBaseDn(this.baseDN);
        ldapServer.setConfidentialityRequired(this.setConfidentialityRequired);
        TcpTransport ldap = new TcpTransport(this.bindHost, this.bindPort, 3, 50);
        ldapServer.addTransports(new Transport[]{ldap});
        if (this.enableSSL || this.enableStartTLS) {
            ldapServer.setKeystoreFile(this.keystoreFile);
            ldapServer.setCertificatePassword(this.certPassword);
            if (this.enableSSL) {
                TcpTransport ldaps = new TcpTransport(this.bindHost, this.bindLdapsPort, 3, 50);
                ldaps.setEnableSSL(true);
                ldapServer.addTransports(new Transport[]{ldaps});
                if (ldaps.isSSLEnabled()) {
                    log.info((Object)"Enabled SSL support on the LDAP server.");
                }
            }
            if (this.enableStartTLS) {
                try {
                    ldapServer.addExtendedOperationHandler((ExtendedOperationHandler)new StartTlsHandler());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot add the StartTLS extension handler: ", e);
                }
                for (ExtendedOperationHandler eoh : ldapServer.getExtendedOperationHandlers()) {
                    if (!eoh.getOid().equals("1.3.6.1.4.1.1466.20037")) continue;
                    log.info((Object)"Enabled StartTLS support on the LDAP server.");
                    break;
                }
            }
        }
        if (this.setConfidentialityRequired) {
            ldapServer.setConfidentialityRequired(true);
            if (ldapServer.isConfidentialityRequired()) {
                log.info((Object)"Configured the LDAP server to accepts only requests with a secured connection.");
            }
        }
        ldapServer.setDirectoryService(this.directoryService);
        try {
            ldapServer.addExtendedOperationHandler((ExtendedOperationHandler)new PwdModifyHandler());
        }
        catch (LdapException le) {
            throw new IllegalStateException("It wasn't possible to add PwdModifyHandler");
        }
        if (this.enableAccessControl) {
            if (this.enableAnonymousAccess) {
                throw new IllegalStateException("Illegal to enable both the access control subsystem and the anonymous access at the same time! See: http://directory.apache.org/apacheds/gen-docs/latest/apidocs/src-html/org/apache/directory/server/core/DefaultDirectoryService.html#line.399 for details.");
            }
            this.directoryService.setAccessControlEnabled(true);
            if (this.directoryService.isAccessControlEnabled()) {
                log.info((Object)"Enabled basic access control checks on the LDAP server.");
            }
        } else if (this.enableAnonymousAccess) {
            this.directoryService.setAllowAnonymousAccess(true);
            this.directoryService.setAccessControlEnabled(false);
            if (this.directoryService.isAllowAnonymousAccess() && !this.directoryService.isAccessControlEnabled()) {
                log.info((Object)"Enabled anonymous access on the LDAP server.");
            }
        }
        return ldapServer;
    }

    private void importLdif() throws Exception {
        InputStream is;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hostname", this.bindHost);
        if (this.ldapSaslPrincipal != null) {
            map.put("ldapSaslPrincipal", this.ldapSaslPrincipal);
        }
        if ((is = FindFile.findFile((String)this.ldifFile)) == null) {
            throw new IllegalStateException("LDIF file not found on classpath or on file system. Location was: " + this.ldifFile);
        }
        String ldifContent = StrSubstitutor.replace((Object)StreamUtil.readString((InputStream)is), map);
        log.info((Object)("Content of LDIF: " + ldifContent));
        SchemaManager schemaManager = this.directoryService.getSchemaManager();
        LDAPEmbeddedServer.importLdifContent(this.directoryService, ldifContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importLdifContent(DirectoryService directoryService, String ldifContent) throws Exception {
        try (LdifReader ldifReader = new LdifReader(IOUtils.toInputStream((String)ldifContent));){
            for (LdifEntry ldifEntry : ldifReader) {
                try {
                    directoryService.getAdminSession().add((Entry)new DefaultEntry(directoryService.getSchemaManager(), ldifEntry.getEntry()));
                }
                catch (LdapEntryAlreadyExistsException ignore) {
                    log.info((Object)("Entry " + String.valueOf(ldifEntry.getDn()) + " already exists. Ignoring."));
                }
            }
        }
    }

    public void stop() throws Exception {
        this.stopLdapServer();
        this.shutdownDirectoryService();
    }

    protected void stopLdapServer() {
        log.info((Object)"Stopping LDAP server.");
        this.ldapServer.stop();
    }

    protected void shutdownDirectoryService() throws Exception {
        log.info((Object)"Stopping Directory service.");
        this.directoryService.shutdown();
        File instanceDir = this.directoryService.getInstanceLayout().getInstanceDirectory();
        if (this.directoryServiceFactory.equals(DSF_INMEMORY)) {
            log.infof("Removing Directory service workfiles: %s", (Object)instanceDir.getAbsolutePath());
            FileUtils.deleteDirectory((File)instanceDir);
        } else {
            log.info((Object)("Working LDAP directory not deleted. Delete it manually if you want to start with fresh LDAP data. Directory location: " + instanceDir.getAbsolutePath()));
        }
    }
}

