/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.util.Sessions;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.adapters.undertow.UndertowHttpFacade;

public abstract class UndertowRequestAuthenticator
extends RequestAuthenticator {
    protected SecurityContext securityContext;
    protected HttpServerExchange exchange;

    public UndertowRequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, int sslRedirectPort, SecurityContext securityContext, HttpServerExchange exchange, AdapterTokenStore tokenStore) {
        super(facade, deployment, tokenStore, sslRedirectPort);
        this.securityContext = securityContext;
        this.exchange = exchange;
    }

    protected void propagateKeycloakContext(KeycloakUndertowAccount account) {
        this.exchange.putAttachment(UndertowHttpFacade.KEYCLOAK_SECURITY_CONTEXT_KEY, (Object)account.getKeycloakSecurityContext());
    }

    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator(this, this.facade, this.deployment, this.sslRedirectPort){

            protected void saveRequest() {
            }
        };
    }

    protected void completeOAuthAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal) {
        KeycloakUndertowAccount account = this.createAccount(principal);
        this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
        this.propagateKeycloakContext(account);
        this.tokenStore.saveAccountInfo((KeycloakAccount)account);
    }

    protected void completeBearerAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal) {
        KeycloakUndertowAccount account = this.createAccount(principal);
        this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
        this.propagateKeycloakContext(account);
    }

    protected String getHttpSessionId(boolean create) {
        if (create) {
            Session session = Sessions.getOrCreateSession((HttpServerExchange)this.exchange);
            return session.getId();
        }
        Session session = Sessions.getSession((HttpServerExchange)this.exchange);
        return session != null ? session.getId() : null;
    }

    protected abstract KeycloakUndertowAccount createAccount(KeycloakPrincipal<RefreshableKeycloakSecurityContext> var1);
}

