/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.ServletSessionConfig;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.undertow.ServletKeycloakAuthMech;
import org.keycloak.adapters.undertow.ServletPreAuthActionsHandler;
import org.keycloak.adapters.undertow.UndertowAuthenticatedActionsHandler;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class KeycloakServletExtension
implements ServletExtension {
    protected static Logger log = Logger.getLogger(KeycloakServletExtension.class);

    public boolean isAuthenticationMechanismPresent(DeploymentInfo deploymentInfo, String mechanismName) {
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        if (loginConfig != null) {
            for (AuthMethodConfig method : loginConfig.getAuthMethods()) {
                if (!method.getName().equalsIgnoreCase(mechanismName)) continue;
                return true;
            }
        }
        return false;
    }

    private InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.json.adapterConfig");
        if (json == null) {
            return null;
        }
        return new ByteArrayInputStream(json.getBytes());
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        if (!this.isAuthenticationMechanismPresent(deploymentInfo, "KEYCLOAK")) {
            log.info((Object)"auth-method is not keycloak!");
            return;
        }
        log.info((Object)"KeycloakServletException initialization");
        InputStream is = this.getJSONFromServletContext(servletContext);
        if (is == null) {
            is = servletContext.getResourceAsStream("/WEB-INF/keycloak.json");
        }
        if (is == null) {
            throw new RuntimeException("Unable to find realm config in /WEB-INF/keycloak.json or in keycloak subsystem.");
        }
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)is);
        UndertowUserSessionManagement userSessionManagement = new UndertowUserSessionManagement(deployment);
        final ServletKeycloakAuthMech mech = this.createAuthenticationMechanism(deploymentInfo, deployment, userSessionManagement);
        UndertowAuthenticatedActionsHandler.Wrapper actions = new UndertowAuthenticatedActionsHandler.Wrapper(deployment);
        deploymentInfo.addOuterHandlerChainWrapper((HandlerWrapper)new ServletPreAuthActionsHandler.Wrapper(deployment, userSessionManagement));
        deploymentInfo.addAuthenticationMechanism("KEYCLOAK", new AuthenticationMechanismFactory(){

            public AuthenticationMechanism create(String s, FormParserFactory formParserFactory, Map<String, String> stringStringMap) {
                return mech;
            }
        });
        deploymentInfo.addInnerHandlerChainWrapper((HandlerWrapper)actions);
        deploymentInfo.setIdentityManager(new IdentityManager(){

            public Account verify(Account account) {
                return account;
            }

            public Account verify(String id, Credential credential) {
                throw new IllegalStateException("Should never be called in Keycloak flow");
            }

            public Account verify(Credential credential) {
                throw new IllegalStateException("Should never be called in Keycloak flow");
            }
        });
        log.info((Object)("Setting jsession cookie path to: " + deploymentInfo.getContextPath()));
        ServletSessionConfig cookieConfig = new ServletSessionConfig();
        cookieConfig.setPath(deploymentInfo.getContextPath());
        deploymentInfo.setServletSessionConfig(cookieConfig);
    }

    protected ServletKeycloakAuthMech createAuthenticationMechanism(DeploymentInfo deploymentInfo, KeycloakDeployment deployment, UndertowUserSessionManagement userSessionManagement) {
        log.info((Object)"creating ServletKeycloakAuthMech");
        return new ServletKeycloakAuthMech(deployment, userSessionManagement, deploymentInfo.getConfidentialPortManager());
    }
}

