/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.keycloak.RealmConfiguration;
import org.keycloak.ResourceMetadata;
import org.keycloak.SkeletonKeySession;
import org.keycloak.adapters.config.ManagedResourceConfig;
import org.keycloak.adapters.undertow.KeycloakAuthenticationMechanism;
import org.keycloak.adapters.undertow.OAuthAuthenticator;
import org.keycloak.adapters.undertow.ServletOAuthAuthenticator;

public class ServletKeycloakAuthenticationMechanism
extends KeycloakAuthenticationMechanism {
    protected ConfidentialPortManager portManager;

    public ServletKeycloakAuthenticationMechanism(ResourceMetadata resourceMetadata, ManagedResourceConfig config, RealmConfiguration realmConfig, ConfidentialPortManager portManager) {
        super(resourceMetadata, config, realmConfig);
        this.portManager = portManager;
    }

    @Override
    protected OAuthAuthenticator createOAuthAuthenticator(HttpServerExchange exchange) {
        return new ServletOAuthAuthenticator(exchange, this.realmConfig, this.portManager);
    }

    @Override
    protected void propagateBearer(HttpServerExchange exchange, SkeletonKeySession session) {
        super.propagateBearer(exchange, session);
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        req.setAttribute(SkeletonKeySession.class.getName(), (Object)session);
    }

    @Override
    protected void propagateOauth(HttpServerExchange exchange, SkeletonKeySession skSession) {
        super.propagateOauth(exchange, skSession);
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        req.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
        HttpSession session = req.getSession(true);
        session.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
    }
}

