/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.keycloak.adapters.config.ManagedResourceConfig;
import org.keycloak.adapters.config.ManagedResourceConfigLoader;
import org.keycloak.adapters.undertow.PreflightCorsHandler;
import org.keycloak.adapters.undertow.ServletAuthenticatedActionsHandler;
import org.keycloak.adapters.undertow.ServletKeycloakAuthenticationMechanism;
import org.keycloak.adapters.undertow.ServletPropagateSessionHandler;

public class KeycloakServletExtension
implements ServletExtension {
    protected Logger log = Logger.getLogger(KeycloakServletExtension.class);

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        if (deploymentInfo.getLoginConfig() == null || !deploymentInfo.getLoginConfig().getAuthMethod().equalsIgnoreCase("keycloak")) {
            this.log.info((Object)"auth-method is not keycloak!");
            return;
        }
        this.log.info((Object)"KeycloakServletException initialization");
        deploymentInfo.setIgnoreStandardAuthenticationMechanism(true);
        InputStream is = servletContext.getResourceAsStream("/WEB-INF/keycloak.json");
        if (is == null) {
            throw new RuntimeException("Unable to find /WEB-INF/keycloak.json configuration file");
        }
        ManagedResourceConfigLoader loader = new ManagedResourceConfigLoader(is);
        loader.init(true);
        ManagedResourceConfig keycloakConfig = loader.getRemoteSkeletonKeyConfig();
        PreflightCorsHandler.Wrapper preflight = new PreflightCorsHandler.Wrapper(keycloakConfig);
        ServletKeycloakAuthenticationMechanism auth = new ServletKeycloakAuthenticationMechanism(loader.getResourceMetadata(), keycloakConfig, loader.getRealmConfiguration(), deploymentInfo.getConfidentialPortManager());
        ServletAuthenticatedActionsHandler.Wrapper actions = new ServletAuthenticatedActionsHandler.Wrapper(keycloakConfig);
        deploymentInfo.addInitialHandlerChainWrapper((HandlerWrapper)preflight);
        deploymentInfo.addAuthenticationMechanism((AuthenticationMechanism)auth);
        deploymentInfo.addInnerHandlerChainWrapper(ServletPropagateSessionHandler.WRAPPER);
        deploymentInfo.addInnerHandlerChainWrapper((HandlerWrapper)actions);
        deploymentInfo.setIdentityManager(new IdentityManager(){

            public Account verify(Account account) {
                KeycloakServletExtension.this.log.info((Object)"Verifying account in IdentityManager");
                return account;
            }

            public Account verify(String id, Credential credential) {
                KeycloakServletExtension.this.log.warn((Object)"Shouldn't call verify!!!");
                throw new IllegalStateException("Not allowed");
            }

            public Account verify(Credential credential) {
                KeycloakServletExtension.this.log.warn((Object)"Shouldn't call verify!!!");
                throw new IllegalStateException("Not allowed");
            }
        });
        this.log.info((Object)("Setting jsession cookie path to: " + deploymentInfo.getContextPath()));
        ServletSessionConfig cookieConfig = new ServletSessionConfig();
        cookieConfig.setPath(deploymentInfo.getContextPath());
        deploymentInfo.setServletSessionConfig(cookieConfig);
    }
}

