/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.database;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.keycloak.test.framework.database.DatabaseConfig;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.oracle.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public class TestDatabase {
    private static final Logger LOGGER = Logger.getLogger(TestDatabase.class);
    private final DatabaseConfig databaseConfig;
    private GenericContainer<?> container;

    public TestDatabase(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
    }

    public void start() {
        if (this.databaseConfig.getContainerImage() != null) {
            this.container = this.createContainer();
            this.container.withStartupTimeout(Duration.ofMinutes(30L)).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(TestDatabase.class))).withEnv(this.databaseConfig.getEnv()).start();
            try {
                if (this.databaseConfig.getPostStartCommand() != null) {
                    LOGGER.tracev("Running post start command: " + this.databaseConfig.getPostStartCommand(), new Object[0]);
                    String result = this.container.execInContainer(new String[]{"bash", "-c", this.databaseConfig.getPostStartCommand()}).getStdout();
                    LOGGER.tracev(result, new Object[0]);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.databaseConfig.url(this.getJdbcUrl());
            if (this.container instanceof MSSQLServerContainer) {
                this.databaseConfig.username(((JdbcDatabaseContainer)this.container).getUsername());
                this.databaseConfig.password(((JdbcDatabaseContainer)this.container).getPassword());
            }
        }
    }

    public void stop() {
        if (this.databaseConfig.getContainerImage() != null) {
            this.container.stop();
            this.container = null;
        } else if ("dev-mem".equals(this.databaseConfig.getVendor())) {
            // empty if block
        }
    }

    public Map<String, String> getServerConfig() {
        return this.databaseConfig.toConfig();
    }

    public String getJdbcUrl() {
        return ((JdbcDatabaseContainer)this.container).getJdbcUrl();
    }

    private JdbcDatabaseContainer<?> configureJdbcContainer(JdbcDatabaseContainer<?> jdbcDatabaseContainer) {
        if (jdbcDatabaseContainer instanceof MSSQLServerContainer) {
            return jdbcDatabaseContainer;
        }
        return jdbcDatabaseContainer.withDatabaseName("keycloak").withUsername(this.databaseConfig.getUsername()).withPassword(this.databaseConfig.getPassword());
    }

    private GenericContainer<?> createContainer() {
        return switch (this.databaseConfig.getVendor()) {
            case "postgres" -> {
                DockerImageName POSTGRES = DockerImageName.parse((String)this.databaseConfig.getContainerImage());
                yield this.configureJdbcContainer((JdbcDatabaseContainer<?>)new PostgreSQLContainer(POSTGRES));
            }
            case "mariadb" -> {
                DockerImageName MARIADB = DockerImageName.parse((String)this.databaseConfig.getContainerImage());
                yield this.configureJdbcContainer((JdbcDatabaseContainer<?>)new MariaDBContainer(MARIADB));
            }
            case "mysql" -> {
                DockerImageName MYSQL = DockerImageName.parse((String)this.databaseConfig.getContainerImage());
                yield this.configureJdbcContainer((JdbcDatabaseContainer<?>)new MySQLContainer(MYSQL));
            }
            case "mssql" -> {
                DockerImageName MSSQL = DockerImageName.parse((String)this.databaseConfig.getContainerImage());
                yield this.configureJdbcContainer((JdbcDatabaseContainer<?>)new MSSQLServerContainer(MSSQL));
            }
            case "oracle" -> {
                DockerImageName ORACLE = DockerImageName.parse((String)this.databaseConfig.getContainerImage());
                yield this.configureJdbcContainer((JdbcDatabaseContainer<?>)new OracleContainer(ORACLE));
            }
            default -> throw new RuntimeException("Unsupported database: " + this.databaseConfig.getVendor());
        };
    }
}

