/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.realm;

import java.util.Arrays;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.test.framework.realm.Collections;
import org.keycloak.test.framework.realm.Representations;

public class RealmConfigBuilder {
    private final RealmRepresentation representation = new RealmRepresentation();

    public RealmConfigBuilder() {
        this.representation.setEnabled(Boolean.valueOf(true));
    }

    public RealmConfigBuilder name(String name) {
        this.representation.setRealm(name);
        return this;
    }

    public RealmConfigBuilder roles(String ... roleNames) {
        if (this.representation.getRoles() == null) {
            this.representation.setRoles(new RolesRepresentation());
        }
        this.representation.getRoles().setRealm(Collections.combine(this.representation.getRoles().getRealm(), Arrays.stream(roleNames).map(Representations::toRole)));
        return this;
    }

    public RealmConfigBuilder groups(String ... groupsNames) {
        this.representation.setGroups(Collections.combine(this.representation.getGroups(), Arrays.stream(groupsNames).map(Representations::toGroup)));
        return this;
    }

    public RealmRepresentation build() {
        return this.representation;
    }
}

