/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.keycloak.test.framework.config.Config;
import org.keycloak.test.framework.injection.DefaultAnnotationProxy;
import org.keycloak.test.framework.injection.InstanceContext;
import org.keycloak.test.framework.injection.LifeCycle;
import org.keycloak.test.framework.injection.RequestedInstance;
import org.keycloak.test.framework.injection.StringUtil;
import org.keycloak.test.framework.injection.Supplier;
import org.keycloak.test.framework.injection.ValueTypeAlias;

public class Registry
implements ExtensionContext.Store.CloseableResource {
    private static final Logger LOGGER = Logger.getLogger(Registry.class);
    private ExtensionContext currentContext;
    private final List<Supplier<?, ?>> suppliers = new LinkedList();
    private final List<InstanceContext<?, ?>> deployedInstances = new LinkedList();
    private final List<RequestedInstance<?, ?>> requestedInstances = new LinkedList();

    public Registry() {
        this.loadSuppliers();
    }

    public ExtensionContext getCurrentContext() {
        return this.currentContext;
    }

    public void setCurrentContext(ExtensionContext currentContext) {
        this.currentContext = currentContext;
    }

    public <T> T getDependency(Class<T> typeClass, String ref, InstanceContext dependent) {
        T dependency = this.getDeployedDependency(typeClass, ref = StringUtil.convertEmptyToNull(ref), dependent);
        if (dependency != null) {
            return dependency;
        }
        dependency = this.getRequestedDependency(typeClass, ref, dependent);
        if (dependency != null) {
            return dependency;
        }
        dependency = this.getUnConfiguredDependency(typeClass, ref, dependent);
        if (dependency != null) {
            return dependency;
        }
        throw new RuntimeException("Dependency not found: " + typeClass);
    }

    private <T> T getDeployedDependency(Class<T> typeClass, String ref, InstanceContext dependent) {
        InstanceContext dependency = this.getDeployedInstance(typeClass, ref);
        if (dependency != null) {
            dependency.registerDependency(dependent);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracev("Injecting existing dependency {0} into {1}", (Object)dependency.getSupplier().getClass().getSimpleName(), (Object)dependent.getSupplier().getClass().getSimpleName());
            }
            return dependency.getValue();
        }
        return null;
    }

    private <T> T getRequestedDependency(Class<T> typeClass, String ref, InstanceContext dependent) {
        RequestedInstance requestedDependency = this.getRequestedInstance(typeClass, ref);
        if (requestedDependency != null) {
            InstanceContext dependency = new InstanceContext(this, requestedDependency.getSupplier(), requestedDependency.getAnnotation(), requestedDependency.getValueType());
            dependency.setValue(requestedDependency.getSupplier().getValue(dependency));
            dependency.registerDependency(dependent);
            this.deployedInstances.add(dependency);
            this.requestedInstances.remove(requestedDependency);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracev("Injecting requested dependency {0} into {1}", (Object)dependency.getSupplier().getClass().getSimpleName(), (Object)dependent.getSupplier().getClass().getSimpleName());
            }
            return dependency.getValue();
        }
        return null;
    }

    private <T> T getUnConfiguredDependency(Class<T> typeClass, String ref, InstanceContext dependent) {
        Optional<Supplier> supplied = this.suppliers.stream().filter(s -> s.getValueType().equals(typeClass)).findFirst();
        if (supplied.isPresent()) {
            Supplier supplier = supplied.get();
            Annotation defaultAnnotation = (Annotation)DefaultAnnotationProxy.proxy(supplier.getAnnotationClass());
            InstanceContext<T, Annotation> dependency = new InstanceContext<T, Annotation>(this, supplier, defaultAnnotation, typeClass);
            dependency.registerDependency(dependent);
            dependency.setValue(supplier.getValue(dependency));
            this.deployedInstances.add(dependency);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracev("Injecting un-configured dependency {0} into {1}", (Object)dependency.getSupplier().getClass().getSimpleName(), (Object)dependent.getSupplier().getClass().getSimpleName());
            }
            return dependency.getValue();
        }
        return null;
    }

    public void beforeEach(Object testInstance) {
        this.findRequestedInstances(testInstance);
        this.matchDeployedInstancesWithRequestedInstances();
        this.deployRequestedInstances();
        this.injectFields(testInstance);
        this.invokeBeforeEachOnSuppliers();
    }

    private void findRequestedInstances(Object testInstance) {
        Class<?> testClass = testInstance.getClass();
        RequestedInstance<?, ?> requestedServerInstance = this.createRequestedInstance(testClass.getAnnotations(), null);
        if (requestedServerInstance != null) {
            this.requestedInstances.add(requestedServerInstance);
        }
        for (Field f : testClass.getDeclaredFields()) {
            RequestedInstance<?, ?> requestedInstance = this.createRequestedInstance(f.getAnnotations(), f.getType());
            if (requestedInstance == null) continue;
            this.requestedInstances.add(requestedInstance);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracev("Requested suppliers: {0}", (Object)this.requestedInstances.stream().map(r -> r.getSupplier().getClass().getSimpleName()).collect(Collectors.joining(", ")));
        }
    }

    private void matchDeployedInstancesWithRequestedInstances() {
        Iterator<RequestedInstance<?, ?>> itr = this.requestedInstances.iterator();
        while (itr.hasNext()) {
            RequestedInstance<?, ?> requestedInstance = itr.next();
            InstanceContext deployedInstance = this.getDeployedInstance(requestedInstance);
            if (deployedInstance == null) continue;
            if (requestedInstance.getLifeCycle().equals((Object)deployedInstance.getLifeCycle()) && deployedInstance.getSupplier().compatible(deployedInstance, requestedInstance)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.tracev("Reusing compatible: {0}", (Object)deployedInstance.getSupplier().getClass().getSimpleName());
                }
                itr.remove();
                continue;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracev("Destroying non-compatible: {0}", (Object)deployedInstance.getSupplier().getClass().getSimpleName());
            }
            this.destroy(deployedInstance);
        }
    }

    private void deployRequestedInstances() {
        while (!this.requestedInstances.isEmpty()) {
            RequestedInstance<?, ?> requestedInstance = this.requestedInstances.remove(0);
            if (this.getDeployedInstance(requestedInstance) != null) continue;
            InstanceContext instance = new InstanceContext(this, requestedInstance.getSupplier(), requestedInstance.getAnnotation(), requestedInstance.getValueType());
            instance.setValue(requestedInstance.getSupplier().getValue(instance));
            this.deployedInstances.add(instance);
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.tracev("Created instance: {0}", (Object)requestedInstance.getSupplier().getClass().getSimpleName());
        }
    }

    private void injectFields(Object testInstance) {
        for (Field f : testInstance.getClass().getDeclaredFields()) {
            InstanceContext<?, ?> instance = this.getDeployedInstance(f.getType(), f.getAnnotations());
            if (instance == null) continue;
            try {
                f.setAccessible(true);
                f.set(testInstance, instance.getValue());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void afterAll() {
        LOGGER.trace((Object)"Closing instances with class lifecycle");
        List<InstanceContext> destroy = this.deployedInstances.stream().filter(i -> i.getLifeCycle().equals((Object)LifeCycle.CLASS)).toList();
        destroy.forEach(this::destroy);
    }

    public void afterEach() {
        LOGGER.trace((Object)"Closing instances with method lifecycle");
        List<InstanceContext> destroy = this.deployedInstances.stream().filter(i -> i.getLifeCycle().equals((Object)LifeCycle.METHOD)).toList();
        destroy.forEach(this::destroy);
    }

    public void close() {
        LOGGER.trace((Object)"Closing all instances");
        List destroy = this.deployedInstances.stream().toList();
        destroy.forEach(this::destroy);
    }

    List<Supplier<?, ?>> getSuppliers() {
        return this.suppliers;
    }

    private RequestedInstance<?, ?> createRequestedInstance(Annotation[] annotations, Class<?> valueType) {
        for (Annotation a : annotations) {
            for (Supplier<?, ?> s : this.suppliers) {
                if (!s.getAnnotationClass().equals(a.annotationType())) continue;
                return new RequestedInstance(s, a, valueType);
            }
        }
        return null;
    }

    private InstanceContext<?, ?> getDeployedInstance(Class<?> valueType, Annotation[] annotations) {
        for (Annotation a : annotations) {
            for (InstanceContext<?, ?> i : this.deployedInstances) {
                Supplier<?, ?> supplier = i.getSupplier();
                if (!supplier.getAnnotationClass().equals(a.annotationType()) || !valueType.isAssignableFrom(i.getValue().getClass()) || !Objects.equals(supplier.getRef(a), i.getRef())) continue;
                return i;
            }
        }
        return null;
    }

    private void destroy(InstanceContext instanceContext) {
        boolean removed = this.deployedInstances.remove(instanceContext);
        if (removed) {
            Set dependencies = instanceContext.getDependencies();
            dependencies.forEach(this::destroy);
            instanceContext.getSupplier().close(instanceContext);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracev("Closed instance: {0}", (Object)instanceContext.getSupplier().getClass().getSimpleName());
            }
        }
    }

    private InstanceContext getDeployedInstance(RequestedInstance requestedInstance) {
        String requestedRef = requestedInstance.getRef();
        Class requestedValueType = requestedInstance.getValueType();
        for (InstanceContext<?, ?> i : this.deployedInstances) {
            if (!Objects.equals(i.getRef(), requestedRef) || !(requestedValueType != null ? requestedValueType.isAssignableFrom(i.getValue().getClass()) : i.getSupplier().equals(requestedInstance.getSupplier()))) continue;
            return i;
        }
        return null;
    }

    private void loadSuppliers() {
        Iterator<Supplier> supplierIterator = ServiceLoader.load(Supplier.class).iterator();
        HashSet loadedValueTypes = new HashSet();
        HashSet<Supplier> skippedSuppliers = new HashSet<Supplier>();
        while (supplierIterator.hasNext()) {
            Supplier supplier = supplierIterator.next();
            boolean shouldAdd = false;
            Class supplierValueType = supplier.getValueType();
            if (!loadedValueTypes.contains(supplierValueType)) {
                String requestedSupplier = Config.getSelectedSupplier(supplierValueType);
                if (requestedSupplier != null) {
                    if (requestedSupplier.equals(supplier.getAlias())) {
                        shouldAdd = true;
                    }
                } else {
                    shouldAdd = true;
                }
            }
            if (shouldAdd) {
                this.suppliers.add(supplier);
                loadedValueTypes.add(supplierValueType);
                continue;
            }
            skippedSuppliers.add(supplier);
        }
        if (LOGGER.isTraceEnabled()) {
            StringBuilder loaded = new StringBuilder();
            loaded.append("Loaded suppliers:");
            for (Supplier<?, ?> s : this.suppliers) {
                loaded.append("\n - " + ValueTypeAlias.getAlias(s.getValueType()) + " --> " + s.getAlias());
            }
            LOGGER.trace((Object)loaded.toString());
            StringBuilder skipped = new StringBuilder();
            skipped.append("Skipped suppliers:");
            for (Supplier s : skippedSuppliers) {
                skipped.append("\n - " + ValueTypeAlias.getAlias(s.getValueType()) + " --> " + s.getAlias());
            }
            LOGGER.trace((Object)skipped.toString());
        }
    }

    private InstanceContext getDeployedInstance(Class typeClass, String ref) {
        return this.deployedInstances.stream().filter(i -> i.getSupplier().getValueType().equals(typeClass) && Objects.equals(i.getRef(), ref)).findFirst().orElse(null);
    }

    private RequestedInstance getRequestedInstance(Class typeClass, String ref) {
        return this.requestedInstances.stream().filter(i -> i.getSupplier().getValueType().equals(typeClass) && Objects.equals(i.getRef(), ref)).findFirst().orElse(null);
    }

    private void invokeBeforeEachOnSuppliers() {
        for (InstanceContext<?, ?> i : this.deployedInstances) {
            i.getSupplier().onBeforeEach(i);
        }
    }
}

