/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.realm;

import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.test.framework.realm.Collections;
import org.keycloak.test.framework.realm.Representations;

public class UserConfigBuilder {
    private final UserRepresentation representation = new UserRepresentation();

    public UserConfigBuilder() {
        this.representation.setEnabled(Boolean.valueOf(true));
    }

    public UserConfigBuilder username(String username) {
        this.representation.setUsername(username);
        return this;
    }

    public UserConfigBuilder name(String firstName, String lastName) {
        this.representation.setFirstName(firstName);
        this.representation.setLastName(lastName);
        return this;
    }

    public UserConfigBuilder email(String email) {
        this.representation.setEmail(email);
        return this;
    }

    public UserConfigBuilder password(String password) {
        this.representation.setCredentials(Collections.combine(this.representation.getCredentials(), Representations.toCredential("password", password)));
        return this;
    }

    public UserConfigBuilder roles(String ... roles) {
        this.representation.setRealmRoles(Collections.combine(this.representation.getRealmRoles(), roles));
        return this;
    }

    public UserConfigBuilder groups(String ... groups) {
        this.representation.setGroups(Collections.combine(this.representation.getGroups(), groups));
        return this;
    }

    public UserRepresentation build() {
        return this.representation;
    }
}

