/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.oauth;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.TokenRevocationRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.test.framework.oauth.OAuthCallbackServer;
import org.keycloak.test.framework.realm.ClientConfig;
import org.keycloak.test.framework.realm.ManagedClient;
import org.keycloak.test.framework.realm.ManagedRealm;
import org.keycloak.test.framework.util.ApiUtil;

public class OAuthClient {
    private final ManagedRealm realm;
    private final ManagedClient client;
    private final OAuthCallbackServer callbackServer;
    private OIDCProviderMetadata oidcProviderMetadata;

    public OAuthClient(ManagedRealm realm, ClientConfig clientConfig) {
        this.realm = realm;
        this.client = this.registerClient(clientConfig);
        this.callbackServer = new OAuthCallbackServer();
    }

    private ManagedClient registerClient(ClientConfig clientConfig) {
        ClientRepresentation clientRepresentation = clientConfig.getRepresentation();
        Response response = this.realm.admin().clients().create(clientRepresentation);
        String id = ApiUtil.handleCreatedResponse(response);
        clientRepresentation.setId(id);
        return new ManagedClient(clientRepresentation, this.realm.admin().clients().get(id));
    }

    public TokenResponse clientCredentialGrant() throws IOException, GeneralException {
        ClientCredentialsGrant clientGrant = new ClientCredentialsGrant();
        ClientAuthentication clientAuthentication = this.getClientAuthentication();
        URI tokenEndpoint = this.getOIDCProviderMetadata().getTokenEndpointURI();
        TokenRequest tokenRequest = new TokenRequest(tokenEndpoint, clientAuthentication, (AuthorizationGrant)clientGrant);
        return TokenResponse.parse((HTTPResponse)tokenRequest.toHTTPRequest().send());
    }

    public TokenResponse tokenRequest(AuthorizationCode authorizationCode) throws IOException, GeneralException {
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant(authorizationCode, this.callbackServer.getRedirectionUri());
        ClientAuthentication clientAuthentication = this.getClientAuthentication();
        URI tokenEndpoint = this.getOIDCProviderMetadata().getTokenEndpointURI();
        TokenRequest tokenRequest = new TokenRequest(tokenEndpoint, clientAuthentication, (AuthorizationGrant)grant);
        return TokenResponse.parse((HTTPResponse)tokenRequest.toHTTPRequest().send());
    }

    public TokenIntrospectionResponse introspection(AccessToken accessToken) throws IOException, GeneralException {
        ClientAuthentication clientAuthentication = this.getClientAuthentication();
        URI introspectionEndpoint = this.getOIDCProviderMetadata().getIntrospectionEndpointURI();
        TokenIntrospectionRequest introspectionRequest = new TokenIntrospectionRequest(introspectionEndpoint, clientAuthentication, (Token)accessToken);
        return TokenIntrospectionResponse.parse((HTTPResponse)introspectionRequest.toHTTPRequest().send());
    }

    public HTTPResponse revokeAccessToken(AccessToken token) throws GeneralException, IOException {
        URI revocationEndpoint = this.getOIDCProviderMetadata().getRevocationEndpointURI();
        TokenRevocationRequest revocationRequest = new TokenRevocationRequest(revocationEndpoint, this.getClientAuthentication(), (Token)token);
        return revocationRequest.toHTTPRequest().send();
    }

    public URL authorizationRequest() throws IOException, GeneralException {
        URI authorizationEndpoint = this.getOIDCProviderMetadata().getAuthorizationEndpointURI();
        State state = new State();
        ClientID clientID = new ClientID(this.client.getClientId());
        AuthorizationRequest authorizationRequest = new AuthorizationRequest.Builder(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), clientID).state(state).redirectionURI(this.callbackServer.getRedirectionUri()).endpointURI(authorizationEndpoint).build();
        return authorizationRequest.toURI().toURL();
    }

    public List<URI> getCallbacks() {
        return this.callbackServer.getCallbacks();
    }

    public void close() {
        this.client.admin().remove();
        this.callbackServer.close();
    }

    private ClientAuthentication getClientAuthentication() {
        ClientID clientID = new ClientID(this.client.getClientId());
        Secret clientSecret = new Secret(this.client.getSecret());
        return new ClientSecretBasic(clientID, clientSecret);
    }

    private OIDCProviderMetadata getOIDCProviderMetadata() throws GeneralException, IOException {
        if (this.oidcProviderMetadata == null) {
            Issuer issuer = new Issuer(this.realm.getBaseUrl());
            this.oidcProviderMetadata = OIDCProviderMetadata.resolve((Issuer)issuer);
        }
        return this.oidcProviderMetadata;
    }
}

